package com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers

import android.content.Context
import com.exner.tools.jkbikemechanicaldisasterprevention.R

class RideLevel {

    companion object {
        fun getRideLevelQuickRide(): Int {
            return 1
        }

        fun getRideLevelDayOut(): Int {
            return 2
        }

        fun getRideLevelHolidays(): Int {
            return 3
        }

        fun getListOfRideLevels(): List<Int> {
            return listOf(1, 2, 3)
        }

        fun getLabel(context: Context, level: Int?): String {
            when (level) {
                null -> return context.getString(R.string.ride_level_all_levels)

                1 -> return context.getString(R.string.ride_level_quick_ride)

                2 -> return context.getString(R.string.ride_level_day_out)

                3 -> return context.getString(R.string.ride_level_holidays)
            }

            return context.getString(R.string.ride_level_unknown)
        }

        fun getHeading(context: Context, level: Int?): String {
            when (level) {
                1 -> return "Pre - Quick Ride Checklist"

                2 -> return "Pre - Big Day Out Checklist"

                3 -> return "Pre - Holiday Checklist"
            }
            return "Unknown"
        }

        fun getTimeframe(context: Context, level: Int?): String {
            when (level) {
                1 -> return "Night before"

                2 -> return "3 days before"

                3 -> return "2 weeks before"
            }
            return "Unknown"
        }

        fun getDescription(context: Context, level: Int?): String {
            when (level) {
                1 -> return "Ensure that the bare minimum is good to go, on short duration rides where you are never far from easy recovery/walk out."

                2 -> return "Elements to be confirmed in good working order before a long duration ride, likely a long walk from easy recovery or on terrain where you really don’t want something to suddenly break."

                3 -> return "A much more complete check of the components and hardware that you want to ensure are in tip-top shape before you go on a riding holiday."
            }
            return "Unknown"
        }

    }
}