package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.wrapContentSize
import androidx.compose.material3.Button
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ExposedDropdownMenuDefaults
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.RideLevel

@Composable
fun DefaultRideLevelSelectorActivity(
    rideLevel: Int?,
    onItemSelected: (Int?) -> Unit
) {
    DefaultRideLevelSelectorWithSpacer(
        rideLevel,
        onItemSelected,
        stringResource(R.string.dropdown_lbl_select_a_level)
    )
}

@Composable
fun DefaultRideLevelSelectorTemplate(
    rideLevel: Int?,
    onItemSelected: (Int?) -> Unit
) {
    DefaultRideLevelSelectorWithSpacer(
        rideLevel,
        onItemSelected,
        stringResource(R.string.dropdown_lbl_template_for_ride_level)
    )
}

@Composable
@OptIn(ExperimentalMaterial3Api::class)
fun DefaultRideLevelSelectorWithSpacer(
    currentRideLevel: Int?,
    onItemSelected: (Int?) -> Unit,
    labelText: String
) {
    val context = LocalContext.current

    var levelsExpanded by remember {
        mutableStateOf(false)
    }
    Box(
        modifier = Modifier
            .fillMaxWidth()
            .padding(8.dp, 0.dp)
    ) {
        Row(
            modifier = Modifier.fillMaxWidth(),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.End
        ) {
            Text(text = labelText)
            DefaultSpacer()
            Box {
                Button(
                    onClick = { levelsExpanded = true }
                ) {
                    if (currentRideLevel != null) {
                        Text(text = RideLevel.getLabel(context, currentRideLevel))
                    } else {
                        Text(text = stringResource(R.string.dropdown_lbl_select_a_level))
                    }
                }
                DropdownMenu(
                    expanded = levelsExpanded,
                    onDismissRequest = { levelsExpanded = false }) {
                    DropdownMenuItem(
                        text = { Text(text = stringResource(R.string.dropdown_item_all_levels)) },
                        onClick = {
                            onItemSelected(null)
                            levelsExpanded = false
                        },
                        contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                    )
                    RideLevel.getListOfRideLevels().forEach { level ->
                        DropdownMenuItem(
                            text = { Text(text = RideLevel.getLabel(context, level)) },
                            onClick = {
                                onItemSelected(level)
                                levelsExpanded = false
                            },
                            contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                        )
                    }
                }
            }
        }
    }

    DefaultSpacer()
}

@Composable
@OptIn(ExperimentalMaterial3Api::class)
fun RideLevelSelectorForLists(
    currentRideLevel: Int?,
    onItemSelected: (Int?) -> Unit,
) {
    val context = LocalContext.current

    var levelsExpanded by remember {
        mutableStateOf(false)
    }
    Box(
        modifier = Modifier
            .fillMaxWidth()
            .padding(8.dp, 0.dp)
            .wrapContentSize(Alignment.TopEnd)
    ) {
        Row(
            verticalAlignment = Alignment.CenterVertically,
        ) {
            Text(text = stringResource(R.string.dropdown_lbl_ride_level_name))
            DefaultSpacer()
            Box {
                Button(
                    onClick = { levelsExpanded = true }
                ) {
                    if (currentRideLevel != null) {
                        Text(text = RideLevel.getLabel(context, currentRideLevel))
                    } else {
                        Text(text = stringResource(R.string.dropdown_item_all_levels))
                    }
                }
                DropdownMenu(
                    expanded = levelsExpanded,
                    onDismissRequest = { levelsExpanded = false }) {
                    DropdownMenuItem(
                        text = { Text(text = stringResource(R.string.dropdown_item_all_levels)) },
                        onClick = {
                            onItemSelected(null)
                            levelsExpanded = false
                        },
                        contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                    )
                    RideLevel.getListOfRideLevels().forEach { level ->
                        DropdownMenuItem(
                            text = { Text(text = RideLevel.getLabel(context, level)) },
                            onClick = {
                                onItemSelected(level)
                                levelsExpanded = false
                            },
                            contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                        )
                    }
                }
            }
        }
    }
    DefaultSpacer()
}