package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ExposedDropdownMenuDefaults
import androidx.compose.material3.OutlinedButton
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.SupportedLanguages

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun LanguageSelector(
    currentLanguage: String?,
    labelText: String,
    onLanguageSelected: (String?) -> Unit
) {
    val context = LocalContext.current

    var dropdownExpanded by remember { mutableStateOf(false) }
    Box(
        modifier = Modifier
            .fillMaxWidth()
            .padding(8.dp, 0.dp)
    ) {
        Row(
            modifier = Modifier
                .fillMaxWidth()
                .padding(8.dp, 0.dp),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween
        ) {
            Text(
                modifier = Modifier.fillMaxWidth(0.5f),
                text = labelText
            )

            Box {
                // TODO the size of this button is not ideal
                OutlinedButton(
                    onClick = { dropdownExpanded = true }
                ) {
                    if (currentLanguage != null) {
                        Text(
                            text = SupportedLanguages.getLabel(context, currentLanguage),
                            maxLines = 1
                        )
                    } else {
                        Text(text = stringResource(R.string.select_a_language))
                    }
                }
                DropdownMenu(
                    expanded = dropdownExpanded,
                    onDismissRequest = { dropdownExpanded = false }) {
                    DropdownMenuItem(
                        text = { Text(text = stringResource(R.string.default_system_language)) },
                        onClick = {
                            onLanguageSelected("default")
                            dropdownExpanded = false
                        },
                        contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                    )
                    SupportedLanguages.getListOfSupportedLanguages().forEach { languageCode ->
                        DropdownMenuItem(
                            text = {
                                Text(
                                    text = SupportedLanguages.getLabel(
                                        context,
                                        languageCode
                                    )
                                )
                            },
                            onClick = {
                                onLanguageSelected(languageCode)
                                dropdownExpanded = false
                            },
                            contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                        )
                    }
                }
            }
        }
    }
    DefaultSpacer()
}