package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.animation.AnimatedVisibility
import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.Button
import androidx.compose.material3.Card
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import com.exner.tools.jkbikemechanicaldisasterprevention.R

@Composable
fun ImportBikeDataDialog(
    onDismissRequest: () -> Unit,
    onConfirmation: (Boolean, Long) -> Unit
) {
    var currentDate: Long? by remember { mutableStateOf(null) }

    var isEbike: Boolean by remember { mutableStateOf(false) }

    Dialog(onDismissRequest = { onDismissRequest() }) {
        Card(
            modifier = Modifier
                .fillMaxWidth()
                .height(300.dp)
                .padding(16.dp),
            shape = RoundedCornerShape(8.dp),
        ) {
            Column(
                modifier = Modifier
                    .fillMaxSize()
                    .padding(8.dp),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {
                DefaultDateSelectorWithSpacer(
                    selectedDate = currentDate,
                    label = stringResource(R.string.lbl_first_use_date),
                    onDateSelected = {
                        currentDate = it
                    },
                    placeholder = stringResource(R.string.lbl_first_use_date)
                )
                DefaultSpacer()
                TextAndSwitch(
                    text = stringResource(R.string.lbl_is_an_ebike),
                    checked = isEbike
                ) {
                    isEbike = it
                }
                DefaultSpacer()
                AnimatedVisibility(currentDate != null) {
                    Button(onClick = {
                        onConfirmation(isEbike, currentDate!!)
                    }) {
                        Text(text = stringResource(R.string.btn_desc_save_the_bike))
                    }
                }
            }
        }
    }
}
