package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.gestures.awaitEachGesture
import androidx.compose.foundation.gestures.awaitFirstDown
import androidx.compose.foundation.gestures.waitForUpOrCancellation
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.rememberScrollState
import androidx.compose.foundation.verticalScroll
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.DateRange
import androidx.compose.material3.DatePicker
import androidx.compose.material3.DatePickerDefaults
import androidx.compose.material3.DatePickerDialog
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.Icon
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.material3.rememberDatePickerState
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Modifier
import androidx.compose.ui.input.pointer.PointerEventPass
import androidx.compose.ui.input.pointer.pointerInput
import androidx.compose.ui.res.stringResource
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.convertMillisToDate
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.convertMillisToDateAndTime

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun DatePickerModal(
    onDateSelected: (Long?) -> Unit,
    onDismiss: () -> Unit
) {
    val datePickerState = rememberDatePickerState()

    DatePickerDialog(
        onDismissRequest = onDismiss,
        confirmButton = {
            TextButton(onClick = {
                onDateSelected(datePickerState.selectedDateMillis)
                onDismiss()
            }) {
                Text(stringResource(R.string.dialog_btn_text_done))
            }
        },
        dismissButton = {
            TextButton(onClick = onDismiss) {
                Text(stringResource(R.string.dialog_btn_text_cancel))
            }
        }
    ) {
        DatePicker(
            state = datePickerState,
            modifier = Modifier.verticalScroll(rememberScrollState()),
            dateFormatter = remember { DatePickerDefaults.dateFormatter() },
        )
    }
}

@Composable
fun DefaultDateSelectorWithSpacer(
    selectedDate: Long?,
    label: String,
    placeholder: String?,
    onDateSelected: (Long?) -> Unit
) {
    val realPlaceholder = placeholder ?: label
    var showCreatedDateModal by remember { mutableStateOf(false) }
    OutlinedTextField(
        value = selectedDate?.let { convertMillisToDate(it) } ?: "",
        onValueChange = { },
        label = { Text(text = label) },
        placeholder = { Text(text = realPlaceholder) },
        trailingIcon = {
            Icon(
                Icons.Default.DateRange,
                contentDescription = stringResource(R.string.dialog_trigger_select_date)
            )
        },
        modifier = Modifier
            .fillMaxWidth()
            .pointerInput(selectedDate) {
                awaitEachGesture {
                    // Modifier.clickable doesn't work for text fields, so we use Modifier.pointerInput
                    // in the Initial pass to observe events before the text field consumes them
                    // in the Main pass.
                    awaitFirstDown(pass = PointerEventPass.Initial)
                    val upEvent =
                        waitForUpOrCancellation(pass = PointerEventPass.Initial)
                    if (upEvent != null) {
                        showCreatedDateModal = true
                    }
                }
            }
    )

    if (showCreatedDateModal) {
        DatePickerModal(
            onDateSelected = {
                if (it != null) {
                    onDateSelected(it)
                }
            },
            onDismiss = { showCreatedDateModal = false }
        )
    }
    DefaultSpacer()
}

@Composable
fun DefaultDateSelectorNullableWithSpacer(
    selectedDate: Long?,
    label: String,
    placeholder: String?,
    onDateSelected: (Long?) -> Unit
) {
    val realPlaceholder = placeholder ?: label
    var showCreatedDateModal by remember { mutableStateOf(false) }
    OutlinedTextField(
        value = selectedDate?.let { convertMillisToDate(it) } ?: "",
        onValueChange = { },
        label = { Text(text = label) },
        placeholder = { Text(text = realPlaceholder) },
        trailingIcon = {
            Icon(
                Icons.Default.DateRange,
                contentDescription = stringResource(R.string.dialog_trigger_select_date)
            )
        },
        modifier = Modifier
            .fillMaxWidth()
            .pointerInput(selectedDate) {
                awaitEachGesture {
                    // Modifier.clickable doesn't work for text fields, so we use Modifier.pointerInput
                    // in the Initial pass to observe events before the text field consumes them
                    // in the Main pass.
                    awaitFirstDown(pass = PointerEventPass.Initial)
                    val upEvent =
                        waitForUpOrCancellation(pass = PointerEventPass.Initial)
                    if (upEvent != null) {
                        showCreatedDateModal = true
                    }
                }
            }
    )

    if (showCreatedDateModal) {
        DatePickerModal(
            onDateSelected = {
                if (it != null) {
                    onDateSelected(it)
                }
            },
            onDismiss = { showCreatedDateModal = false }
        )
    }
    DefaultSpacer()
}

@Composable
fun DefaultInstantSelectorWithSpacer(
    selectedDate: Long?,
    label: String,
    placeholder: String?,
    onDateSelected: (Long?) -> Unit
) {
    val realPlaceholder = placeholder ?: label
    var showCreatedDateModal by remember { mutableStateOf(false) }
    OutlinedTextField(
        value = selectedDate?.let { convertMillisToDateAndTime(it) } ?: "",
        onValueChange = { },
        label = { Text(text = label) },
        placeholder = { Text(text = realPlaceholder) },
        trailingIcon = {
            Icon(
                Icons.Default.DateRange,
                contentDescription = stringResource(R.string.dialog_trigger_select_date)
            )
        },
        modifier = Modifier
            .fillMaxWidth()
            .pointerInput(selectedDate) {
                awaitEachGesture {
                    // Modifier.clickable doesn't work for text fields, so we use Modifier.pointerInput
                    // in the Initial pass to observe events before the text field consumes them
                    // in the Main pass.
                    awaitFirstDown(pass = PointerEventPass.Initial)
                    val upEvent =
                        waitForUpOrCancellation(pass = PointerEventPass.Initial)
                    if (upEvent != null) {
                        showCreatedDateModal = true
                    }
                }
            }
    )

    if (showCreatedDateModal) {
        DatePickerModal(
            onDateSelected = {
                if (it != null) {
                    onDateSelected(it)
                }
            },
            onDismiss = { showCreatedDateModal = false }
        )
    }
    DefaultSpacer()
}

