package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.shape.RoundedCornerShape
import androidx.compose.material3.Button
import androidx.compose.material3.Card
import androidx.compose.material3.FilledTonalButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.material3.TextButton
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableIntStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import androidx.compose.ui.window.Dialog
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.WearLevel
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.toLocalisedString

@Composable
fun ComponentWearLevelDialog(
    onDismissRequest: () -> Unit,
    onConfirmation: (WearLevel) -> Unit,
    componentName: String?,
    startIndex: Int = 0
) {
    var selectedIndex by remember { mutableIntStateOf(startIndex) }
    val options = listOf(WearLevel.NEW, WearLevel.USED, WearLevel.DUE_FOR_REPLACEMENT)

    val context = LocalContext.current

    val topRoundedCornerShape = RoundedCornerShape(8.dp, 8.dp, 0.dp, 0.dp)
    val midRoundedCornerShape = RoundedCornerShape(0.dp, 0.dp, 0.dp, 0.dp)
    val botRoundedCornerShape = RoundedCornerShape(0.dp, 0.dp, 8.dp, 8.dp)

    Dialog(onDismissRequest = {
        onDismissRequest()
    }) {
        Card(shape = RoundedCornerShape(8.dp)) {
            Column(
                modifier = Modifier
                    .fillMaxWidth()
                    .padding(8.dp),
                verticalArrangement = Arrangement.Center,
                horizontalAlignment = Alignment.CenterHorizontally,
            ) {
                Text(
                    text = stringResource(R.string.state_of_component) + if (componentName != null) {
                        " " + componentName
                    } else {
                        ""
                    }
                )
                DefaultSpacer()
                options.forEachIndexed { index, label ->
                    if (index == selectedIndex) {
                        Button(
                            modifier = Modifier
                                .fillMaxWidth()
                                .padding(1.dp),
                            onClick = {
                                selectedIndex = index
                                onConfirmation(options[selectedIndex])
                            },
                            shape = when (index) {
                                0 -> {
                                    topRoundedCornerShape
                                }

                                2 -> {
                                    botRoundedCornerShape
                                }

                                else -> {
                                    midRoundedCornerShape
                                }
                            }
                        ) {
                            Text(
                                text = toLocalisedString(
                                    wearLevel = label,
                                    context = context
                                )
                            )
                        }
                    } else {
                        FilledTonalButton(
                            modifier = Modifier
                                .fillMaxWidth()
                                .padding(1.dp),
                            onClick = {
                                selectedIndex = index
                                onConfirmation(options[selectedIndex])
                            },
                            shape = when (index) {
                                0 -> {
                                    topRoundedCornerShape
                                }

                                2 -> {
                                    botRoundedCornerShape
                                }

                                else -> {
                                    midRoundedCornerShape
                                }
                            }
                        ) {
                            Text(
                                text = toLocalisedString(
                                    wearLevel = label,
                                    context = context
                                )
                            )
                        }
                    }
                }
                DefaultSpacer()
                TextButton(
                    onClick = {
                        onDismissRequest()
                    },
                    modifier = Modifier.padding(8.dp)
                ) {
                    Text(
                        text = stringResource(R.string.dialog_btn_text_skip),
                        style = MaterialTheme.typography.bodySmall
                    )
                }
            }
        }
    }
}
