package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.layout.Arrangement
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.padding
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.ExperimentalMaterial3Api
import androidx.compose.material3.ExposedDropdownMenuAnchorType
import androidx.compose.material3.ExposedDropdownMenuBox
import androidx.compose.material3.ExposedDropdownMenuDefaults
import androidx.compose.material3.OutlinedTextField
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.Alignment
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Component

@OptIn(ExperimentalMaterial3Api::class)
@Composable
fun DefaultComponentSelectorWithSpacer(
    value: String,
    label: String,
    onMenuItemClick: (Long?) -> Unit,
    components: List<Component>
) {
    var bikeSelectorExpanded by remember { mutableStateOf(false) }
    ExposedDropdownMenuBox(
        expanded = bikeSelectorExpanded,
        onExpandedChange = { bikeSelectorExpanded = !bikeSelectorExpanded }
    ) {
        Row(
            modifier = Modifier
                .fillMaxWidth(),
            verticalAlignment = Alignment.CenterVertically,
            horizontalArrangement = Arrangement.SpaceBetween
        ) {
            OutlinedTextField(
                // The `menuAnchor` modifier must be passed to the text field for correctness.
                modifier = Modifier
                    .menuAnchor(
                        type = ExposedDropdownMenuAnchorType.PrimaryEditable,
                        enabled = true
                    )
                    .fillMaxWidth()
                    .padding(8.dp),
                readOnly = true,
                value = value,
                onValueChange = {},
                label = { Text(text = label) },
                trailingIcon = { ExposedDropdownMenuDefaults.TrailingIcon(expanded = bikeSelectorExpanded) },
            )
        }
        ExposedDropdownMenu(
            expanded = bikeSelectorExpanded,
            onDismissRequest = { bikeSelectorExpanded = false }) {
            DropdownMenuItem(
                text = { Text(text = stringResource(R.string.dropdown_item_none)) },
                onClick = {
                    onMenuItemClick(null)
                    bikeSelectorExpanded = false
                },
                contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
            )
            components.forEach { component ->
                DropdownMenuItem(
                    text = { Text(text = component.name) },
                    onClick = {
                        onMenuItemClick(component.uid)
                        bikeSelectorExpanded = false
                    },
                    contentPadding = ExposedDropdownMenuDefaults.ItemContentPadding,
                )
            }
        }
    }
    DefaultSpacer()
}

