package com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents

import androidx.compose.foundation.background
import androidx.compose.foundation.border
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.RowScope
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxWidth
import androidx.compose.foundation.layout.height
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.lazy.LazyColumn
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.graphics.Color
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.Dp
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.jkbike.components.ComponentAnalysisResults

@Composable
fun ComponentAnalysisResultsTable(
    componentAnalysisResults: ComponentAnalysisResults
) {
    val labelColumnWeight = 0.45f
    val totalColumnWeight = 0.25f
    val avgColumnWeight = 0.3f

    LazyColumn(
        modifier = Modifier
            .fillMaxWidth()
            .height(170.dp)
            .padding(8.dp)
    ) {
        item {
            Row(
                modifier = Modifier
                    .background(MaterialTheme.colorScheme.secondaryContainer)
            ) {
                TableCell("", labelColumnWeight)
                TableCell(stringResource(R.string.cell_hdr_totals), totalColumnWeight)
                TableCell(stringResource(R.string.cell_hdr_averages), avgColumnWeight)
            }
        }

        item {
            Row {
                TableCell("${stringResource(R.string.cell_hdr_mileage)} (${componentAnalysisResults.distanceMeasure})", labelColumnWeight)
                TableCell(componentAnalysisResults.totalUsageMiles.toString(), totalColumnWeight)
                TableCell(componentAnalysisResults.averageUsageMiles.toString(), avgColumnWeight)
            }
        }

        item {
            Row {
                TableCell(stringResource(R.string.cell_hdr_days_in_use), labelColumnWeight)
                TableCell(componentAnalysisResults.totalUsageDays.toString(), totalColumnWeight)
                TableCell(componentAnalysisResults.averageUsageDays.toString(), avgColumnWeight)
            }
        }
    }
}

@Composable
fun RowScope.TableCell(
    text: String,
    weight: Float
) {
    Text(
        text = text,
        Modifier
            .border(Dp.Hairline, Color.Black)
            .fillMaxHeight()
            .weight(weight)
            .padding(4.dp)
    )
}