package com.exner.tools.jkbikemechanicaldisasterprevention.ui

import androidx.compose.foundation.layout.Box
import androidx.compose.foundation.layout.Column
import androidx.compose.foundation.layout.IntrinsicSize
import androidx.compose.foundation.layout.Row
import androidx.compose.foundation.layout.Spacer
import androidx.compose.foundation.layout.consumeWindowInsets
import androidx.compose.foundation.layout.fillMaxHeight
import androidx.compose.foundation.layout.fillMaxSize
import androidx.compose.foundation.layout.padding
import androidx.compose.foundation.layout.width
import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.Checklist
import androidx.compose.material.icons.filled.Dataset
import androidx.compose.material.icons.filled.Event
import androidx.compose.material.icons.filled.PedalBike
import androidx.compose.material.icons.filled.Settings
import androidx.compose.material3.BottomAppBar
import androidx.compose.material3.BottomAppBarDefaults
import androidx.compose.material3.ExtendedFloatingActionButton
import androidx.compose.material3.FloatingActionButtonDefaults
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.NavigationDrawerItem
import androidx.compose.material3.NavigationRail
import androidx.compose.material3.NavigationRailItem
import androidx.compose.material3.PermanentDrawerSheet
import androidx.compose.material3.PermanentNavigationDrawer
import androidx.compose.material3.Scaffold
import androidx.compose.material3.Surface
import androidx.compose.material3.Text
import androidx.compose.material3.windowsizeclass.WindowHeightSizeClass
import androidx.compose.material3.windowsizeclass.WindowSizeClass
import androidx.compose.runtime.Composable
import androidx.compose.ui.Modifier
import androidx.compose.ui.res.stringResource
import androidx.compose.ui.unit.dp
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.DefaultSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.customComponents.PageHeaderTextWithSpacer
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsAction
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.KJsMenuItem
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.NavigationStyle
import com.ramcosta.composedestinations.generated.destinations.ListRideHistoryDestination
import com.ramcosta.composedestinations.generated.destinations.ManageActivitiesDestination
import com.ramcosta.composedestinations.generated.destinations.ManageBikesDestination
import com.ramcosta.composedestinations.generated.destinations.ManageComponentsDestination
import com.ramcosta.composedestinations.generated.destinations.SettingsDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator
import com.ramcosta.composedestinations.spec.BaseRoute

@Composable
fun KJsResponsiveNavigation(
    currentDestination: BaseRoute,
    destinationsNavigator: DestinationsNavigator,
    windowSizeClass: WindowSizeClass,
    myActions: List<KJsAction> = emptyList(),
    myFloatingActionButton: KJsAction? = null,
    headline: String,
    helpUrlString: String? = null,
    advancedFunctionality: Boolean = false,
    content: @Composable () -> Unit
) {
    val listOfMenuItems: List<KJsMenuItem> = listOf(
    )
    val listOfMenuItemsForRail: MutableList<KJsMenuItem> = mutableListOf(
        KJsMenuItem(
            selected = ManageBikesDestination == currentDestination,
            onClick = {
                destinationsNavigator.navigate(ManageBikesDestination)
            },
            icon = Icons.Default.PedalBike,
            label = stringResource(R.string.menu_item_manage_bikes_components)
        ),
        KJsMenuItem(
            selected = ManageActivitiesDestination == currentDestination,
            onClick = {
                destinationsNavigator.navigate(ManageActivitiesDestination)
            },
            icon = Icons.Default.Checklist,
            label = stringResource(R.string.menu_item_manage_activities)
        ),
    )
    if (advancedFunctionality) {
        listOfMenuItemsForRail.add(KJsMenuItem(
            selected = ManageComponentsDestination == currentDestination,
            onClick = {
                destinationsNavigator.navigate(ManageComponentsDestination())
            },
            icon = Icons.Default.Dataset,
            label = stringResource(R.string.menu_item_manage_components)
        ))
    }
    listOfMenuItemsForRail.add(KJsMenuItem(
        selected = ListRideHistoryDestination == currentDestination,
        onClick = {
            destinationsNavigator.navigate(ListRideHistoryDestination)
        },
        icon = Icons.Default.Event,
        label = stringResource(R.string.menu_item_list_ride_history)
    ))

    val navigationStyle =
        NavigationStyle.getNavigationStyleForWidthSizeClass(windowSizeClass.widthSizeClass)

    when (navigationStyle) {
        NavigationStyle.BOTTOM_BAR -> {
            Scaffold(
                content = { innerPadding ->
                    Column(
                        modifier = Modifier
                            .fillMaxSize()
                            .padding(innerPadding)
                            .padding(4.dp, 0.dp)

                    ) {
                        if (windowSizeClass.heightSizeClass != WindowHeightSizeClass.Compact && headline.isNotBlank()) {
                            PageHeaderTextWithSpacer(headline, helpUrlString)
                        }
                        Surface {
                            content()
                        }
                    }
                },
                bottomBar = {
                    if (myActions.isNotEmpty() || myFloatingActionButton != null) {
                        BottomAppBar(
                            actions = {
                                myActions.forEach { kjsAction ->
                                    IconButton(onClick = {
                                        kjsAction.onClick()
                                    }) {
                                        Icon(
                                            imageVector = kjsAction.imageVector,
                                            contentDescription = kjsAction.contentDescription
                                        )
                                    }
                                }
                            },
                            floatingActionButton = {
                                if (myFloatingActionButton != null && myFloatingActionButton.enabled) {
                                    ExtendedFloatingActionButton(
                                        text = { Text(text = myFloatingActionButton.contentDescription) },
                                        icon = {
                                            Icon(
                                                imageVector = myFloatingActionButton.imageVector,
                                                contentDescription = myFloatingActionButton.contentDescription
                                            )
                                        },
                                        onClick = {
                                            myFloatingActionButton.onClick()
                                        },
                                        containerColor = BottomAppBarDefaults.bottomAppBarFabColor,
                                        elevation = FloatingActionButtonDefaults.bottomAppBarFabElevation()
                                    )
                                }
                            }
                        )
                    }
                }
            )
        }

        NavigationStyle.LEFT_RAIL -> { // medium screen width
            Row(
                modifier = Modifier.fillMaxSize()
            ) {
                NavigationRail(
                    modifier = Modifier.fillMaxHeight()
                ) {
                    listOfMenuItems.forEach { item ->
                        NavigationRailItem(
                            selected = item.selected,
                            onClick = item.onClick,
                            label = {
                                Text(text = item.label)
                            },
                            icon = {
                                Icon(
                                    imageVector = item.icon,
                                    contentDescription = item.label
                                )
                            },
                        )
                    }
                    Spacer(modifier = Modifier.weight(0.5f))
                    NavigationRailItem(
                        selected = SettingsDestination == currentDestination,
                        onClick = {
                            destinationsNavigator.navigate(SettingsDestination)
                        },
                        icon = {
                            Icon(
                                imageVector = Icons.Default.Settings,
                                contentDescription = stringResource(R.string.menu_item_settings)
                            )
                        },
                        label = {
                            Text(stringResource(R.string.menu_item_settings))
                        }
                    )

                }
                DefaultSpacer()
                Scaffold(
                    content = { innerPadding ->
                        Surface(
                            modifier = Modifier
                                .fillMaxSize()
                                .padding(innerPadding)
                                .consumeWindowInsets(innerPadding)
                                .padding(8.dp)
                        ) {
                            content()
                        }
                    },
                    bottomBar = {
                        BottomAppBar(
                            containerColor = MaterialTheme.colorScheme.surface,
                            actions = {
                                myActions.forEach { kjsAction ->
                                    IconButton(onClick = {
                                        kjsAction.onClick()
                                    }) {
                                        Icon(
                                            imageVector = kjsAction.imageVector,
                                            contentDescription = kjsAction.contentDescription
                                        )
                                    }
                                }
                            },
                            floatingActionButton = {
                                if (myFloatingActionButton != null && myFloatingActionButton.enabled) {
                                    ExtendedFloatingActionButton(
                                        onClick = {
                                            myFloatingActionButton.onClick()
                                        },
                                        icon = {
                                            Icon(
                                                imageVector = myFloatingActionButton.imageVector,
                                                contentDescription = myFloatingActionButton.contentDescription
                                            )
                                        },
                                        text = {
                                            Text(text = myFloatingActionButton.contentDescription)
                                        }
                                    )
                                }
                            }
                        )
                    }
                )
            }
        }

        NavigationStyle.LEFT_DRAWER -> { // wide screen
            Box {
                PermanentNavigationDrawer(
                    drawerContent = {
                        PermanentDrawerSheet(
                            modifier = Modifier
                                .width(IntrinsicSize.Min)
                                .padding(8.dp, 0.dp)
                        ) {
                            Column {
                                listOfMenuItems.forEach { item ->
                                    NavigationDrawerItem(
                                        selected = item.selected,
                                        onClick = item.onClick,
                                        label = {
                                            Text(text = item.label)
                                        },
                                        icon = {
                                            Icon(
                                                imageVector = item.icon,
                                                contentDescription = item.label
                                            )
                                        },
                                    )
                                }
                                Spacer(modifier = Modifier.weight(0.5f))
                                listOfMenuItemsForRail.forEach { item ->
                                    NavigationDrawerItem(
                                        selected = item.selected,
                                        onClick = item.onClick,
                                        label = {
                                            Text(text = item.label)
                                        },
                                        icon = {
                                            Icon(
                                                imageVector = item.icon,
                                                contentDescription = item.label
                                            )
                                        },
                                    )
                                }
                                DefaultSpacer()
                                NavigationDrawerItem(
                                    selected = SettingsDestination == currentDestination,
                                    onClick = {
                                        destinationsNavigator.navigate(SettingsDestination)
                                    },
                                    icon = {
                                        Icon(
                                            imageVector = Icons.Default.Settings,
                                            contentDescription = stringResource(R.string.menu_item_settings)
                                        )
                                    },
                                    label = {
                                        Text(stringResource(R.string.menu_item_settings))
                                    }
                                )
                            }
                        }
                    },
                ) {
                    Scaffold(
                        content = { padding ->
                            Surface(
                                modifier = Modifier
                                    .fillMaxSize()
                                    .padding(padding)
                                    .consumeWindowInsets(padding)
                                    .padding(8.dp)
                            ) {
                                content()
                            }
                        },
                        bottomBar = {
                            BottomAppBar(
                                containerColor = MaterialTheme.colorScheme.surface,
                                actions = {
                                    myActions.forEach { kjsAction ->
                                        IconButton(onClick = {
                                            kjsAction.onClick()
                                        }) {
                                            Icon(
                                                imageVector = kjsAction.imageVector,
                                                contentDescription = kjsAction.contentDescription
                                            )
                                        }
                                    }
                                },
                                floatingActionButton = {
                                    if (myFloatingActionButton != null && myFloatingActionButton.enabled) {
                                        ExtendedFloatingActionButton(
                                            onClick = {
                                                myFloatingActionButton.onClick()
                                            },
                                            icon = {
                                                Icon(
                                                    imageVector = myFloatingActionButton.imageVector,
                                                    contentDescription = myFloatingActionButton.contentDescription
                                                )
                                            },
                                            text = {
                                                Text(text = myFloatingActionButton.contentDescription)
                                            }
                                        )
                                    }
                                }
                            )
                        }
                    )
                }
            }
        }
    }
}