package com.exner.tools.jkbikemechanicaldisasterprevention.ui

import androidx.lifecycle.ViewModel
import androidx.lifecycle.viewModelScope
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.hilt.android.lifecycle.HiltViewModel
import kotlinx.coroutines.flow.MutableStateFlow
import kotlinx.coroutines.flow.SharingStarted
import kotlinx.coroutines.flow.StateFlow
import kotlinx.coroutines.flow.stateIn
import javax.inject.Inject
import kotlin.time.ExperimentalTime

@OptIn(ExperimentalTime::class)
@HiltViewModel
class KJsGlobalScaffoldViewModel @Inject constructor(
    userPreferencesManager: UserPreferencesManager,
    repository: KJsRepository,
) : ViewModel() {

    private val _destinationTitle: MutableStateFlow<String> = MutableStateFlow("")
    val destinationTitle: StateFlow<String> = _destinationTitle

    fun setDestinationTitle(newTitle: String) {
        _destinationTitle.value = newTitle
    }

    val numberOfRetiredComponents = repository.observeNumberOfRetiredComponents

    val stravaEnabled: StateFlow<Boolean> = userPreferencesManager.stravaEnabled().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        false
    )

    val intervalsEnabled: StateFlow<Boolean> = userPreferencesManager.intervalsEnabled().stateIn(
        viewModelScope,
        SharingStarted.WhileSubscribed(),
        false
    )

    val advancedFunctionality: StateFlow<Boolean> =
        userPreferencesManager.advancedFunctionality().stateIn(
            viewModelScope,
            SharingStarted.WhileSubscribed(),
            false
        )
}