package com.exner.tools.jkbikemechanicaldisasterprevention.ui

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.filled.MoreVert
import androidx.compose.material3.DropdownMenu
import androidx.compose.material3.DropdownMenuItem
import androidx.compose.material3.HorizontalDivider
import androidx.compose.material3.Icon
import androidx.compose.material3.IconButton
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.Text
import androidx.compose.runtime.Composable
import androidx.compose.runtime.getValue
import androidx.compose.runtime.mutableStateOf
import androidx.compose.runtime.remember
import androidx.compose.runtime.setValue
import androidx.compose.ui.res.stringResource
import androidx.hilt.navigation.compose.hiltViewModel
import androidx.lifecycle.compose.collectAsStateWithLifecycle
import com.exner.tools.jkbikemechanicaldisasterprevention.R
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.integrations.SyncWithIntervalsViewModel
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.integrations.SyncWithStravaViewModel
import com.ramcosta.composedestinations.generated.destinations.AboutDestination
import com.ramcosta.composedestinations.generated.destinations.ActivityAddDestination
import com.ramcosta.composedestinations.generated.destinations.AutomaticActivitiesGenerationLogListDestination
import com.ramcosta.composedestinations.generated.destinations.BikeAddDestination
import com.ramcosta.composedestinations.generated.destinations.ComponentAddDestination
import com.ramcosta.composedestinations.generated.destinations.ComponentAnalysisDestination
import com.ramcosta.composedestinations.generated.destinations.ExportDataDestination
import com.ramcosta.composedestinations.generated.destinations.ImportDataDestination
import com.ramcosta.composedestinations.generated.destinations.ManageActivitiesDestination
import com.ramcosta.composedestinations.generated.destinations.ManageBikesDestination
import com.ramcosta.composedestinations.generated.destinations.ManageComponentsDestination
import com.ramcosta.composedestinations.generated.destinations.SettingsDestination
import com.ramcosta.composedestinations.generated.destinations.SyncWithIntervalsDestination
import com.ramcosta.composedestinations.generated.destinations.SyncWithStravaDestination
import com.ramcosta.composedestinations.navigation.DestinationsNavigator
import com.ramcosta.composedestinations.spec.DestinationSpec

@Composable
fun KJsGlobalMainMenuAction(
    destination: DestinationSpec?,
    destinationsNavigator: DestinationsNavigator,
    kJsGlobalScaffoldViewModel: KJsGlobalScaffoldViewModel = hiltViewModel(),
    syncWithStravaViewModel: SyncWithStravaViewModel = hiltViewModel(),
    syncWithIntervalsViewModel: SyncWithIntervalsViewModel = hiltViewModel()
) {
    var displayMainMenu by remember { mutableStateOf(false) }

    val numberOfRetiredComponents by kJsGlobalScaffoldViewModel.numberOfRetiredComponents.collectAsStateWithLifecycle(
        initialValue = 0
    )

    val isStravaConnected by syncWithStravaViewModel.isStravaConnected.collectAsStateWithLifecycle()

    val isIntervalsConnected by syncWithIntervalsViewModel.isIntervalsConnected.collectAsStateWithLifecycle()

    val advancedFunctionality by kJsGlobalScaffoldViewModel.advancedFunctionality.collectAsStateWithLifecycle()

    IconButton(
        onClick = {
            displayMainMenu = !displayMainMenu
        }
    ) {
        Icon(
            imageVector = Icons.Default.MoreVert,
            contentDescription = stringResource(R.string.menu)
        )
    }
    DropdownMenu(
        expanded = displayMainMenu,
        onDismissRequest = { displayMainMenu = false }
    ) {
        DropdownMenuItem(
            enabled = destination != BikeAddDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_add_bike),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(BikeAddDestination)
            }
        )
        DropdownMenuItem(
            enabled = destination != ManageBikesDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_manage_bikes_components),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(ManageBikesDestination)
            }
        )
        if (isStravaConnected) {
            DropdownMenuItem(
                enabled = isStravaConnected && destination != SyncWithStravaDestination,
                text = {
                    Text(
                        text = stringResource(R.string.dropdown_item_sync_with_strava),
                        style = MaterialTheme.typography.bodyLarge
                    )
                },
                onClick = {
                    displayMainMenu = false
                    destinationsNavigator.navigate(SyncWithStravaDestination)
                }
            )
        }
        if (isIntervalsConnected) {
            DropdownMenuItem(
                enabled = isIntervalsConnected && destination != SyncWithIntervalsDestination,
                text = {
                    Text(
                        text = stringResource(R.string.dropdown_item_sync_with_intervals),
                        style = MaterialTheme.typography.bodyLarge
                    )
                },
                onClick = {
                    displayMainMenu = false
                    destinationsNavigator.navigate(SyncWithIntervalsDestination)
                }
            )
        }
        HorizontalDivider()
        if (advancedFunctionality) {
            DropdownMenuItem(
                enabled = destination != ComponentAddDestination,
                text = {
                    Text(
                        text = stringResource(R.string.menu_item_add_component),
                        style = MaterialTheme.typography.bodyLarge
                    )
                },
                onClick = {
                    displayMainMenu = false
                    destinationsNavigator.navigate(ComponentAddDestination)
                }
            )
            DropdownMenuItem(
                enabled = destination != ManageComponentsDestination,
                text = {
                    Text(
                        text = stringResource(R.string.menu_item_manage_components),
                        style = MaterialTheme.typography.bodyLarge
                    )
                },
                onClick = {
                    displayMainMenu = false
                    destinationsNavigator.navigate(ManageComponentsDestination())
                }
            )
            if (numberOfRetiredComponents > 0) {
                DropdownMenuItem(
                    enabled = destination != ComponentAnalysisDestination,
                    text = {
                        Text(
                            text = stringResource(R.string.menu_item_analyse_components),
                            style = MaterialTheme.typography.bodyLarge
                        )
                    },
                    onClick = {
                        displayMainMenu = false
                        destinationsNavigator.navigate(ComponentAnalysisDestination)
                    }
                )
            }
            HorizontalDivider()
        }
        DropdownMenuItem(
            enabled = destination != ActivityAddDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_add_activity),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(ActivityAddDestination)
            }
        )
        DropdownMenuItem(
            enabled = destination != ManageActivitiesDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_manage_activities),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(ManageActivitiesDestination)
            }
        )
        HorizontalDivider()
        DropdownMenuItem(
            enabled = destination != SettingsDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_settings),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(SettingsDestination)
            }
        )
        DropdownMenuItem(
            enabled = destination != ImportDataDestination,
            text = {
                Text(
                    text = stringResource(R.string.btn_text_import_data),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(ImportDataDestination)
            }
        )
        DropdownMenuItem(
            enabled = destination != ExportDataDestination,
            text = {
                Text(
                    text = stringResource(R.string.btn_text_export_data),
                    style = MaterialTheme.typography.bodyLarge,
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(ExportDataDestination)
            }
        )
        HorizontalDivider()
        if (advancedFunctionality) {
            DropdownMenuItem(
                enabled = destination != AutomaticActivitiesGenerationLogListDestination,
                text = {
                    Text(
                        text = stringResource(R.string.menu_item_log_list),
                        style = MaterialTheme.typography.bodyLarge
                    )
                },
                onClick = {
                    displayMainMenu = false
                    destinationsNavigator.navigate(AutomaticActivitiesGenerationLogListDestination)
                }
            )
            HorizontalDivider()
        }
        DropdownMenuItem(
            enabled = destination != AboutDestination,
            text = {
                Text(
                    text = stringResource(R.string.menu_item_about),
                    style = MaterialTheme.typography.bodyLarge
                )
            },
            onClick = {
                displayMainMenu = false
                destinationsNavigator.navigate(AboutDestination)
            }
        )
    }
}