package com.exner.tools.jkbikemechanicaldisasterprevention.network.strava.models

import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Serializable
data class StravaSummaryAthlete @OptIn(ExperimentalTime::class) constructor(
    @SerialName("id") val id: Long?,
    @SerialName("user_name") val userName: String?,
    @SerialName("resource_state") val resourceState: Int?, // "2" == Summary
    @SerialName("firstname") val firstName: String?,
    @SerialName("lastname") val lastName: String?,
    @SerialName("profile_medium") val profileMedium: String?,
    @SerialName("profile") val profile: String?,
    @SerialName("city") val city: String?,
    @SerialName("state") val state: String?,
    @SerialName("country") val country: String?,
    @SerialName("sex") val gender: String?,
    @SerialName("premium") val premium: Boolean?,
    @SerialName("summit") val summit: Boolean?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("created_at") val createdAt: Instant?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("update_at") val updatedAt: Instant?,
)
