package com.exner.tools.jkbikemechanicaldisasterprevention.network.strava.models

import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Serializable
data class StravaSummaryActivity @OptIn(ExperimentalTime::class) constructor(
    @SerialName("id") val id: Long?,
    @SerialName("name") val userName: String?,
    @SerialName("resource_state") val resourceState: Int?, // "2" == Summary
    @SerialName("athlete") val athlete: StravaMetaAthlete?,
    @SerialName("type") val type: String?,
    @SerialName("sport_type") val sportType: String?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("start_date") val startDate: Instant?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("start_date_local") val startDateLocal: Instant?,
    @SerialName("gear_id") val gearId: String?,
    // ...
)