package com.exner.tools.jkbikemechanicaldisasterprevention.network.strava.models

import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime

@Serializable
data class StravaDetailedGear @OptIn(ExperimentalTime::class) constructor(
    val id: String?,
    val primary: Boolean?,
    val name: String?,
    val nickname: String?,
    @SerialName("resource_state")
    val resourceState: Int?, // "3" == Detail
    val retired: Boolean?,
    val distance: Float?,
    @SerialName("converted_distance")
    val convertedDistance: Float?,
    @SerialName("brand_name")
    val brandName: String?,
    @SerialName("model_name")
    val modelName: String?,
    @SerialName("frame_type")
    val frameType: Int?,
    val description: String?,
    val weight: Float?
)
