package com.exner.tools.jkbikemechanicaldisasterprevention.network.strava.models

import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.StravaSummaryGear
import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Serializable
data class StravaDetailedAthlete @OptIn(ExperimentalTime::class) constructor(
    @SerialName("id") val id: Long?,
    @SerialName("username") val userName: String?,
    @SerialName("resource_state") val resourceState: Int?, // "2" == Summary
    @SerialName("firstname") val firstName: String?,
    @SerialName("lastname") val lastName: String?,
    @SerialName("profile_medium") val profileMedium: String?,
    @SerialName("profile") val profile: String?,
    @SerialName("city") val city: String?,
    @SerialName("state") val state: String?,
    @SerialName("country") val country: String?,
    @SerialName("sex") val gender: String?,
    @SerialName("summit") val summit: Boolean?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("created_at") val createdAt: Instant?,
    @Serializable(with = InstantAsISO8601StringSerializer::class) @SerialName("updated_at") val updatedAt: Instant?,
    @SerialName("follower_count") val followerCount: Int?,
    @SerialName("friend_count") val friendCount: Int?,
    @SerialName("measurement_preference") val measurementPreference: String?,
    @SerialName("ftp") val ftp: Int?,
    @SerialName("weight") val weight: Float?,
    @SerialName("clubs") val clubs: List<StravaSummaryClub>?,
    @SerialName("bikes") val bikes: List<StravaSummaryGear>?,
    @SerialName("shoes") val shoes: List<StravaSummaryGear>?,
)
