package com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers

import kotlinx.serialization.KSerializer
import kotlinx.serialization.descriptors.PrimitiveKind
import kotlinx.serialization.descriptors.PrimitiveSerialDescriptor
import kotlinx.serialization.descriptors.SerialDescriptor
import kotlinx.serialization.encoding.Decoder
import kotlinx.serialization.encoding.Encoder

object BooleanTinyintSerializer : KSerializer<Boolean> {
    override val descriptor: SerialDescriptor
        get() = PrimitiveSerialDescriptor(
            serialName = "com.exner.tools.BooleanTinyint",
            kind = PrimitiveKind.INT
        )

    override fun serialize(
        encoder: Encoder,
        value: Boolean
    ) {
        val intValue = if (value) {
            1
        } else {
            0
        }
        return encoder.encodeInt(intValue)
    }

    override fun deserialize(decoder: Decoder): Boolean {
        val intValue = decoder.decodeInt()
        return if (intValue == 1) {
            true
        } else {
            false
        }
    }

}