package com.exner.tools.jkbikemechanicaldisasterprevention.di

import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.network.intervals.IntervalsApiManager
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import dagger.Module
import dagger.Provides
import dagger.hilt.InstallIn
import dagger.hilt.components.SingletonComponent
import javax.inject.Singleton

@InstallIn(SingletonComponent::class)
@Module
object WorkerModule {

    @Provides
    @Singleton
    fun provideWorkerFactory(
        repository: KJsRepository,
        userPreferencesManager: UserPreferencesManager,
        intervalsApiManager: IntervalsApiManager
    ): CommonWorkerFactory {
        return CommonWorkerFactory(
            repository = repository,
            userPreferencesManager = userPreferencesManager,
            intervalsApiManager = intervalsApiManager
        )
    }

}