package com.exner.tools.jkbikemechanicaldisasterprevention.di

import android.content.Context
import androidx.work.ListenableWorker
import androidx.work.WorkerFactory
import androidx.work.WorkerParameters
import com.exner.tools.jkbikemechanicaldisasterprevention.database.KJsRepository
import com.exner.tools.jkbikemechanicaldisasterprevention.network.intervals.IntervalsApiManager
import com.exner.tools.jkbikemechanicaldisasterprevention.preferences.UserPreferencesManager
import com.exner.tools.jkbikemechanicaldisasterprevention.scheduler.CheckComponentsIntervalsAndCreateActivitiesWorker
import com.exner.tools.jkbikemechanicaldisasterprevention.scheduler.UpdateBikeDistancesFromIntegrationWorker
import javax.inject.Inject

class CommonWorkerFactory @Inject constructor(
    val repository: KJsRepository,
    val userPreferencesManager: UserPreferencesManager,
    val intervalsApiManager: IntervalsApiManager
) : WorkerFactory() {
    override fun createWorker(
        appContext: Context,
        workerClassName: String,
        workerParameters: WorkerParameters
    ): ListenableWorker? {

        return when (workerClassName) {
            UpdateBikeDistancesFromIntegrationWorker::class.java.name -> UpdateBikeDistancesFromIntegrationWorker(
                appContext =  appContext,
                workerParams = workerParameters,
                repository = repository,
                userPreferencesManager = userPreferencesManager,
                intervalsApiManager = intervalsApiManager
            )

            CheckComponentsIntervalsAndCreateActivitiesWorker::class.java.name -> CheckComponentsIntervalsAndCreateActivitiesWorker(
                appContext = appContext,
                workerParams = workerParameters,
                repository = repository,
                userPreferencesManager = userPreferencesManager
            )

            else -> null
        }
    }
}