package com.exner.tools.jkbikemechanicaldisasterprevention.database.views

import androidx.room.ColumnInfo
import androidx.room.DatabaseView
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.RetirementReason
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.WearLevel
import kotlinx.datetime.LocalDate

@DatabaseView(
    "SELECT name, description, acquisition_date, first_use_date, last_check_date, last_check_mileage, current_mileage, mileage_offset, bike_uid, title_for_automatic_activities, wear_level, retirement_date, retirement_reason, check_interval_miles, check_interval_days, notify_when_activity_created, last_check_notification_mileage, last_check_notification_date, " +
            " uid " +
            "FROM Component WHERE bike_uid IS NULL AND retirement_date IS NULL ORDER BY acquisition_date DESC"
)
data class ShelvedComponents(
    @ColumnInfo(name = "name") val name: String,
    @ColumnInfo(name = "description") val description: String,
    @ColumnInfo(name = "acquisition_date") val acquisitionDate: LocalDate?,
    @ColumnInfo(name = "first_use_date") val firstUseDate: LocalDate?,
    @ColumnInfo(name = "last_check_date") val lastCheckDate: LocalDate?,
    @ColumnInfo(name = "last_check_mileage") val lastCheckMileage: Int?,
    @ColumnInfo(name = "current_mileage") val currentMileage: Int?,
    @ColumnInfo(name = "mileage_offset") val mileageOffset: Int?,

    @ColumnInfo(name = "bike_uid") val bikeUid: Long?,

    @ColumnInfo(name = "title_for_automatic_activities") val titleForAutomaticActivities: String?,

    @ColumnInfo(name = "wear_level") val wearLevel: WearLevel?,
    @ColumnInfo(name = "retirement_date") val retirementDate: LocalDate?,
    @ColumnInfo(name = "retirement_reason") val retirementReason: RetirementReason?,

    @ColumnInfo(name = "check_interval_miles") val checkIntervalMiles: Int?,
    @ColumnInfo(name = "check_interval_days") val checkIntervalDays: Int?,
    @ColumnInfo(name = "notify_when_activity_created")
    val notifyWhenActivityCreated: Boolean,
    @ColumnInfo(name = "last_check_notification_mileage")
    val lastCheckNotificationMileage: Int?,
    @ColumnInfo(name = "last_check_notification_date")
    val lastCheckNotificationDate: LocalDate?,

    @ColumnInfo(name = "uid") val uid: Long
)
