package com.exner.tools.jkbikemechanicaldisasterprevention.database.views

import androidx.room.ColumnInfo
import androidx.room.DatabaseView
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@DatabaseView(
    "SELECT " +
            "r.name as ride_name, r.level as ride_level, r.created_instant as ride_created_instant, r.is_completed as ride_is_completed, r.completed_instant as ride_completed_instant, r.uid as ride_uid, " +
            "b.name as bike_name, b.uid as bike_uid, b.is_active as bike_is_active, " +
            "COUNT(DISTINCT a.uid) as activity_number_total, COUNT(DISTINCT (CASE WHEN a.is_completed = 1 THEN a.uid END)) as activity_number_completed " +
            "FROM Ride r " +
            "LEFT JOIN Bike b ON b.uid = r.bike_uid " +
            "LEFT JOIN Activity a ON r.uid = a.ride_uid " +
            "GROUP By r.uid " +
            "ORDER BY r.created_instant DESC"
)
data class RideWithBikeAndActivityTotals @OptIn(ExperimentalTime::class) constructor(
    @ColumnInfo(name = "bike_name") val bikeName: String?,
    @ColumnInfo(name = "bike_uid") val bikeUid: Long?,
    @ColumnInfo(name = "bike_is_active") val bikeIsActive: Boolean?,
    @ColumnInfo(name = "ride_name") val rideName: String?,
    @ColumnInfo(name = "ride_level") val rideLevel: Int?,
    @ColumnInfo(name = "ride_created_instant") val rideCreatedInstant: Instant?,
    @ColumnInfo(name = "ride_is_completed") val rideIsCompleted: Boolean?,
    @ColumnInfo(name = "ride_completed_instant") val rideCompletedInstant: Instant?,
    @ColumnInfo(name = "ride_uid") val rideUid: Long,
    @ColumnInfo(name = "activity_number_total") val numberOfActivitiesTotal: Int,
    @ColumnInfo(name = "activity_number_completed") val numberOfActivitiesCompleted: Int
)
