package com.exner.tools.jkbikemechanicaldisasterprevention.database.views

import androidx.room.ColumnInfo
import androidx.room.DatabaseView
import kotlin.time.Instant
import kotlinx.datetime.LocalDate
import kotlin.time.ExperimentalTime

@DatabaseView(
    "SELECT " +
            "b.name as bike_name, b.uid as bike_uid, b.is_active as bike_is_active, " +
            "r.name as ride_name, r.level as ride_level, r.is_completed as ride_is_completed, r.completed_instant as ride_completed_instant, " +
            "a.title as activity_title, a.description as activity_description, a.is_completed as activity_is_completed, a.ride_uid as activity_ride_uid, a.created_instant as activity_created_instant, a.due_date as activity_due_date, a.done_instant as activity_done_instant, a.is_ebike_specific as activity_is_ebike_specific, a.ride_level as activity_ride_level, a.component_uid as activity_component_uid, " +
            "a.uid as activity_uid " +
            "FROM Activity a " +
            "LEFT JOIN Bike b ON b.uid = a.bike_uid " +
            "LEFT JOIN Ride r ON r.uid = a.ride_uid " +
            "ORDER BY a.due_date DESC"
)
data class ActivityWithBikeAndRideData @OptIn(ExperimentalTime::class) constructor(
    @ColumnInfo(name = "bike_name") val bikeName: String?,
    @ColumnInfo(name = "bike_uid") val bikeUid: Long?,
    @ColumnInfo(name = "bike_is_active") val bikeIsActive: Boolean?,
    @ColumnInfo(name = "ride_name") val rideName: String?,
    @ColumnInfo(name = "ride_level") val rideLevel: Int?,
    @ColumnInfo(name = "ride_is_completed") val rideIsCompleted: Boolean?,
    @ColumnInfo(name = "ride_completed_instant") val rideCompletedInstant: Instant?,
    @ColumnInfo(name = "activity_title") val activityTitle: String,
    @ColumnInfo(name = "activity_description") val activityDescription: String,
    @ColumnInfo(name = "activity_is_completed") val activityIsCompleted: Boolean,
    @ColumnInfo(name = "activity_ride_uid") val rideUid: Long?,
    @ColumnInfo(name = "activity_created_instant") val activityCreatedInstant: Instant,
    @ColumnInfo(name = "activity_due_date") val activityDueDate: LocalDate?,
    @ColumnInfo(name = "activity_done_instant") val activityDoneDateInstant: Instant?,
    @ColumnInfo(name = "activity_is_ebike_specific") val isEBikeSpecific: Boolean,
    @ColumnInfo(name = "activity_ride_level") val activityRideLevel: Int?,
    @ColumnInfo(name = "activity_component_uid") val activityComponentUid: Long?,
    @ColumnInfo(name = "activity_uid") val activityUid: Long
)
