package com.exner.tools.jkbikemechanicaldisasterprevention.database.views

import androidx.room.ColumnInfo
import androidx.room.DatabaseView
import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable
import kotlin.time.Instant


@DatabaseView(
    "SELECT " +
            "a.title as title, a.description as description, a.is_completed as is_completed, a.bike_uid as bike_uid, a.is_ebike_specific as is_ebike_specific, a.ride_level as ride_level, a.component_uid as component_uid, a.ride_uid as ride_uid, a.created_instant as created_instant, a.due_date as due_date, a.done_instant as done_instant, " +
            "a.uid as uid " +
            "FROM Activity a " +
            "LEFT JOIN Ride r ON r.uid = a.ride_uid " +
            "WHERE a.ride_uid IS NULL OR r.is_completed = 0 " +
            "ORDER BY a.due_date DESC"
)
data class ActivitiesButNotForCompletedRides(
    val title: String,
    val description: String,
    @ColumnInfo(name = "is_completed")
    var isCompleted: Boolean = false,
    @ColumnInfo(name = "bike_uid")
    val bikeUid: Long?,
    @ColumnInfo(name = "is_ebike_specific")
    val isEBikeSpecific: Boolean = false,
    @ColumnInfo(name = "ride_level")
    val rideLevel: Int?,
    @ColumnInfo(name = "component_uid")
    val componentUid: Long?,
    @ColumnInfo(name = "ride_uid")
    val rideUid: Long?,
    @ColumnInfo(name = "created_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val createdInstant: Instant,
    @ColumnInfo(name = "due_date")
    val dueDate: LocalDate?,
    @ColumnInfo(name = "done_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val doneInstant: Instant?,
    val uid: Long
)
