package com.exner.tools.jkbikemechanicaldisasterprevention.database.tools

import android.content.Context
import com.exner.tools.jkbikemechanicaldisasterprevention.R

enum class WearLevel {
    NEW,
    USED,
    DUE_FOR_REPLACEMENT,
}

fun toLocalisedString(wearLevel: WearLevel, context: Context): String {
    return when (wearLevel) {
        WearLevel.NEW -> {
            context.getString(R.string.dropdown_item_wear_level_new)
        }

        WearLevel.USED -> {
            context.getString(R.string.dropdown_item_wear_level_used)
        }

        WearLevel.DUE_FOR_REPLACEMENT -> {
            context.getString(R.string.dropdown_item_wear_level_due_for_replacement)
        }
    }
}

fun wearLevelFromString(input: String?): WearLevel? {
    if (input.isNullOrEmpty()) {
        return null
    }
    return when (input.lowercase()) {
        "new" -> WearLevel.NEW
        "used" -> WearLevel.USED
        "due for replacement" -> WearLevel.DUE_FOR_REPLACEMENT
        else -> WearLevel.USED
    }
}