package com.exner.tools.jkbikemechanicaldisasterprevention.database.tools

import android.content.Context
import com.exner.tools.jkbikemechanicaldisasterprevention.R

enum class RetirementReason {
    WORN,
    IRREPARABLE,
    UPGRADE,
    NO_LONGER_NEEDED,
}

fun toLocalisedString(retirementReason: RetirementReason, context: Context): String {
    return when(retirementReason) {
        RetirementReason.WORN -> {
            context.getString(R.string.dropdown_item_retirement_reason_worn)
        }
        RetirementReason.IRREPARABLE -> {
            context.getString(R.string.dropdown_item_retirement_reason_irreparable)
        }
        RetirementReason.UPGRADE -> {
            context.getString(R.string.dropdown_item_retirement_reason_upgrade)
        }
        RetirementReason.NO_LONGER_NEEDED -> {
            context.getString(R.string.dropdown_item_retirement_reason_no_longer_needed)
        }
    }
}

fun retirementReasonFromString(input: String?): RetirementReason? {
    if (input.isNullOrEmpty()) {
        return null
    }
    return when(input.lowercase()) {
        "worn" -> RetirementReason.WORN
        "irreparable" -> RetirementReason.IRREPARABLE
        "upgrade" -> RetirementReason.UPGRADE
        "no longer needed" -> RetirementReason.NO_LONGER_NEEDED
        else -> RetirementReason.WORN
    }
}