package com.exner.tools.jkbikemechanicaldisasterprevention.database.tools

import android.util.Log
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.TemplateActivity
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.SupportedLanguages
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.serialization.json.Json
import java.net.URL

private const val TAG = "LoadTemplatesFromJsonAndImport"

@OptIn(ExperimentalStdlibApi::class)
fun loadTemplateActivitiesJsonAndImport(
    language: String,
    importDataCallback: (List<TemplateActivity>) -> Unit,
    errorCallback: () -> Unit
) {
    var checkedLanguage = language
    // if we do not know the language, fall back to en
    if (!SupportedLanguages.getListOfSupportedLanguages().contains(language)) {
        // it is not known, so let's go to system language, or en
        checkedLanguage = SupportedLanguages.determineLocaleToLoad()
        Log.d(TAG, "Language code $language unknown, falling back to en.")
    }

    CoroutineScope(Dispatchers.IO).launch {
        try {
            val templateURL =
                URL("https://codeberg.org/jexner/JKBikeTemplateActivities/raw/branch/main/$checkedLanguage/template-activities.json")
            Log.d(TAG, "Trying to get templates...")
            val templateContent = templateURL.readText(Charsets.UTF_8)
            val newRootData = Json.decodeFromString<TemplateActivityRootData?>(templateContent)
            Log.d(TAG, "Received data")
            if (newRootData != null) {
                val newTemplateActivities = newRootData.templateActivities
                Log.d(TAG, "Found ${newTemplateActivities?.size} templates, importing...")
                if (newTemplateActivities != null) {
                    importDataCallback(newTemplateActivities)
                    Log.d(TAG, "Import done.")
                }
            }
        } catch (exception: Exception) {
            Log.e(TAG, "Exception $exception")
            errorCallback()
        }
    }
}
