package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.TemplateActivityType
import kotlinx.serialization.Serializable

@Serializable
@Entity
data class TemplateActivity(
    @ColumnInfo(name = "ride_level")
    val rideLevel: Int?,
    val title: String,
    val description: String,
    @ColumnInfo(name = "is_ebike_specific")
    val isEBikeSpecific: Boolean = false,
    @ColumnInfo(name = "type_of_template")
    val typeOfTemplate: TemplateActivityType = TemplateActivityType.BUILT_IN,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
