package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Serializable
@Entity
data class Ride @OptIn(ExperimentalTime::class) constructor(
    val name: String,
    val level: Int,
    @ColumnInfo(name = "is_completed")
    val completed: Boolean,
    @ColumnInfo(name = "bike_uid")
    val bikeUid: Long?,
    @ColumnInfo(name = "created_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val createdInstant: Instant,
    @ColumnInfo(name = "completed_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val completedInstant: Instant?,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
