package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.RetirementReason
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.WearLevel
import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.BooleanTinyintSerializer
import kotlinx.datetime.LocalDate
import kotlinx.serialization.SerialName
import kotlinx.serialization.Serializable

@Serializable
@Entity
data class Component(
    val name: String,
    val description: String,
    @SerialName("acquisition_date")
    @ColumnInfo(name = "acquisition_date")
    val acquisitionDate: LocalDate?,
    @SerialName("first_use_date")
    @ColumnInfo(name = "first_use_date")
    val firstUseDate: LocalDate?,
    @SerialName("last_check_date")
    @ColumnInfo(name = "last_check_date")
    val lastCheckDate: LocalDate?,
    @SerialName("last_check_mileage")
    @ColumnInfo(name = "last_check_mileage")
    val lastCheckMileage: Int?,
    @SerialName("current_mileage")
    @ColumnInfo(name = "current_mileage")
    val currentMileage: Int?,
    @SerialName("mileage_offset")
    @ColumnInfo(name = "mileage_offset")
    val mileageOffset: Int?,
    @SerialName("bike_uid")
    @ColumnInfo(name = "bike_uid")
    val bikeUid: Long?,
    @SerialName("title_for_automatic_activities")
    @ColumnInfo(name = "title_for_automatic_activities")
    val titleForAutomaticActivities: String?,
    @SerialName("wear_level")
    @ColumnInfo(name = "wear_level")
    val wearLevel: WearLevel?,
    @SerialName("retirement_date")
    @ColumnInfo(name = "retirement_date")
    val retirementDate: LocalDate?,
    @SerialName("retirement_reason")
    @ColumnInfo(name = "retirement_reason")
    val retirementReason: RetirementReason?,
    @SerialName("check_interval_miles")
    @ColumnInfo(name = "check_interval_miles")
    val checkIntervalMiles: Int?,
    @SerialName("check_interval_days")
    @ColumnInfo(name = "check_interval_days")
    val checkIntervalDays: Int?,
    @SerialName("notify_when_activity_created")
    @ColumnInfo(name = "notify_when_activity_created")
    @Serializable(with = BooleanTinyintSerializer::class)
    val notifyWhenActivityCreated: Boolean,
    @SerialName("last_check_notification_mileage")
    @ColumnInfo(name = "last_check_notification_mileage")
    val lastCheckNotificationMileage: Int?,
    @SerialName("last_check_notification_date")
    @ColumnInfo(name = "last_check_notification_date")
    val lastCheckNotificationDate: LocalDate?,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
