package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable

@Serializable
@Entity
data class Bike(
    var name: String,
    @ColumnInfo(name = "build_date")
    val buildDate: LocalDate,
    val mileage: Int = 0,
    @ColumnInfo(name = "last_used_date")
    val lastUsedDate: LocalDate?,
    @ColumnInfo(name = "is_electric")
    val isElectric: Boolean = false,
    @ColumnInfo(name = "is_active")
    val isActive: Boolean = true,
    @ColumnInfo(name = "retirement_date")
    val retirementDate: LocalDate?,
    @ColumnInfo(name = "strava_gear_id")
    val stravaGearId: String?,
    @ColumnInfo(name = "intervals_gear_id")
    val intervalsGearId: String?,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
