package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Entity
data class BackgroundWorkLog @OptIn(ExperimentalTime::class) constructor(
    @ColumnInfo(name = "created_instant")
    val createdInstant: Instant,
    val source: String,
    @ColumnInfo(name = "created_component_uid")
    val createdComponentUid: Long?,
    @ColumnInfo(name = "activity_uid")
    val activityUid: Long?,
    val description: String,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
