package com.exner.tools.jkbikemechanicaldisasterprevention.database.entities

import androidx.room.ColumnInfo
import androidx.room.Entity
import androidx.room.PrimaryKey
import com.exner.tools.jkbikemechanicaldisasterprevention.json.serializers.InstantAsISO8601StringSerializer
import kotlinx.datetime.LocalDate
import kotlinx.serialization.Serializable
import kotlin.time.ExperimentalTime
import kotlin.time.Instant

@Serializable
@Entity
data class Activity @OptIn(ExperimentalTime::class) constructor(
    val title: String,
    val description: String,
    @ColumnInfo(name = "is_completed")
    var isCompleted: Boolean = false,
    @ColumnInfo(name = "bike_uid")
    val bikeUid: Long?,
    @ColumnInfo(name = "is_ebike_specific")
    val isEBikeSpecific: Boolean = false,
    @ColumnInfo(name = "ride_level")
    val rideLevel: Int?,
    @ColumnInfo(name = "component_uid")
    val componentUid: Long?,
    @ColumnInfo(name = "ride_uid")
    val rideUid: Long?,
    @ColumnInfo(name = "created_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val createdInstant: Instant,
    @ColumnInfo(name = "due_date")
    val dueDate: LocalDate?,
    @ColumnInfo(name = "done_instant")
    @Serializable(InstantAsISO8601StringSerializer::class)
    val doneInstant: Instant?,

    @PrimaryKey(autoGenerate = true)
    val uid: Long = 0
)
