package com.exner.tools.jkbikemechanicaldisasterprevention.database

import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.TemplateActivity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.tools.TemplateActivityType
import com.exner.tools.jkbikemechanicaldisasterprevention.ui.helpers.RideLevel
import javax.inject.Provider

class PopulateDatabaseHelpers() {
    val resultingList: MutableList<TemplateActivity> = mutableListOf()

    // this function is a fallback
    // usually, template activities should be loaded from github, in the selected language of the device
    // if we do not have that language, then this code will be used
    fun generatePreparationTemplateActivities(): List<TemplateActivity> {
        // clear the list
        resultingList.clear()

        // create activities for quick ride
        createQuickRideTemplateActivity(
            title = "Check/fix tyre pressure",
            description = "Check pressure on both tyres, and inflate if necessary.",
        )
        createQuickRideTemplateActivity(
            title = "Brake knock test",
            description = "Pull both brakes and rock bike back and forth to test for knocks",
        )
        createQuickRideTemplateActivity(
            title = "Check axles",
            description = "Check that both axles are properly installed and torqued",
        )
        createQuickRideTemplateActivity(
            title = "Check rear derailleur",
            description = "Check that the rear mech is securely attached and not bent or damaged",
        )
        createQuickRideTemplateActivity(
            title = "Check dropper post",
            description = "Check that dropper post moves up, down, and stays where it should",
        )
        createQuickRideTemplateActivity(
            title = "Chain lubed",
            description = "Check that chain is lubed, and re-apply if needed",
        )
        createQuickRideTemplateActivity(
            title = "Check gears",
            description = "Check that gears are indexed properly and all gears can be used",
        )
        createQuickRideTemplateActivity(
            title = "Charge battery",
            description = "Check battery level and charge if needed",
            isEBikeSpecific = true
        )
        createQuickRideTemplateActivity(
            title = "Battery properly installed",
            description = "Make sure that battery and cover are securely mounted and locked",
            isEBikeSpecific = true
        )
        createQuickRideTemplateActivity(
            title = "Electronics OK",
            description = "Check bike computer works, and all ride levels function",
            isEBikeSpecific = true
        )

        // create activities for day out
        createDayOutTemplateActivity(
            title = "Shifter / cable work smoothly",
            description = "Check that shifter and cable work smoothly, replace if needed",
        )

        createDayOutTemplateActivity(
            title = "Check pedals",
            description = "Pedals secure with no play + pedal pins in place",
        )

        createDayOutTemplateActivity(
            title = "Check cleats + shoes",
            description = "SPD cleats secure in shoes and pedal connection working",
        )

        createDayOutTemplateActivity(
            title = "Check chainring",
            description = "Chainring bolts or lockring torqued",
        )

        createDayOutTemplateActivity(
            title = "Check crank bolts",
            description = "Crank bolts torqued",
        )

        createDayOutTemplateActivity(
            title = "Check crank pre-tensioned (if needed)",
            description = "Cranks pre-tensioned (if required by crankset)",
        )

        createDayOutTemplateActivity(
            title = "Check bottom bracket",
            description = "Turn pedals with bike on bike stand ideally with chain removed, listen and feel for grinding",
        )

        createDayOutTemplateActivity(
            title = "Check tyre sealant",
            description = "Shake wheel and listen for liquid. If not, refill sealant",
        )

        createDayOutTemplateActivity(
            title = "Check brake rotor securely attached",
            description = "Check that disc bolts or lockring are properly torqued",
        )

        createDayOutTemplateActivity(
            title = "Check brake pads",
            description = "Check brake pads with wheel out, all round the pads, as they may wear unevenly and look OK from top but a disaster underneath",
        )

        createDayOutTemplateActivity(
            title = "Check wheel bearings",
            description = "Do the wheels rotate freely, without grinding noises",
        )

        createDayOutTemplateActivity(
            title = "Check freehub",
            description = "Check that freehub/cassette is working and does not make unusual noises or play",
        )

        createDayOutTemplateActivity(
            title = "Check spokes",
            description = "Check that spoke tension is similar around the wheels",
        )

        createDayOutTemplateActivity(
            title = "Check stem and faceplate bolts",
            description = "Make sure stem and faceplate bolts are properly torqued. Do this after headset pre-tension check.",
        )

        createDayOutTemplateActivity(
            title = "Check headset pre-tension",
            description = "Make sure headset is pre-tension and bolt properly torqued. Do this before you check the stem and faceplate.",
        )

        createDayOutTemplateActivity(
            title = "Check cockpit",
            description = "Check that all levers and shifters are secured",
        )

        createDayOutTemplateActivity(
            title = "Check dropper lever",
            description = "Dropper lever works smoothly",
        )

        createDayOutTemplateActivity(
            title = "Check whether brakes need bleeding",
            description = "Check brakes don't need to be ‘pumped’ to stop them pulling to the bars",
        )

        createDayOutTemplateActivity(
            title = "Check saddle bolts",
            description = "Saddle bolts torqued",
        )

        createDayOutTemplateActivity(
            title = "Check seatpost bolts",
            description = "Seatpost bolts torqued",
        )

        createDayOutTemplateActivity(
            title = "Check dropper",
            description = "Seatpost works properly (up, down, stays in position)",
        )

        createDayOutTemplateActivity(
            title = "Check suspension works",
            description = "moves freely and correctly pressured",
        )

        createDayOutTemplateActivity(
            title = "Check suspension is clean",
            description = "Not weeping oil from anywhere",
        )

        createDayOutTemplateActivity(
            title = "Check suspension is quiet",
            description = "No squelching sounds",
        )

        createDayOutTemplateActivity(
            title = "Lubricate suspension",
            description = "Lubricate stanchions"
        )

        createDayOutTemplateActivity(
            title = "No noises from drive",
            description = "Drive is smooth with no noises or clunks or grinding",
            isEBikeSpecific = true
        )

        createDayOutTemplateActivity(
            title = "Charge extra battery",
            description = "Extra battery charged and ready",
            isEBikeSpecific = true
        )

        createDayOutTemplateActivity(
            title = "Check motor bolts",
            description = "Motor bolts secure",
            isEBikeSpecific = true
        )


        // create template activities for holidays
        createHolidaysTemplateActivity(
            title = "Wheel bearings rotate smoothly",
            description = "Check whether wheel bearings are turning smoothly, replace if needed",
        )
        createHolidaysTemplateActivity(
            title = "Rims are fine",
            description = "Check rims for cracks or bad dents - if has, replace before holiday",
        )
        createHolidaysTemplateActivity(
            title = "Tyres OK",
            description = "Tyres not over worn or with knobs missing",
        )
        createHolidaysTemplateActivity(
            title = "Grips OK",
            description = "Grips no over worn",
        )
        createHolidaysTemplateActivity(
            title = "Pivot bearings smooth",
            description = "Pivot bearings smooth and travel freely, and greased",
        )
        createHolidaysTemplateActivity(
            title = "Headset bearings smooth",
            description = "Headset bearings smooth and greased",
        )
        createHolidaysTemplateActivity(
            title = "BB bearings smooth",
            description = "BB bearings smooth and greased",
        )
        createHolidaysTemplateActivity(
            title = "Chain is not too worn",
            description = "Chain not beyond .5 (if its, replace whole drivetrain before holiday - chain, cassette, chainring)",
        )
        createHolidaysTemplateActivity(
            title = "Service Suspension",
            description = "Suspension serviced (could be just a lowers/air can service, but better a full rebuild from reputable source e.g. TFT, J-tech, silverfish (fox) etc)",
        )
        createHolidaysTemplateActivity(
            title = "Bleed brakes",
            description = "Bleed brakes",
        )
        createHolidaysTemplateActivity(
            title = "Lube caliper pistons",
            description = "Lube caliper pistons",
        )

        createHolidaysTemplateActivity(
            title = "Use warranty now",
            description = "Issues worth warrantying before holiday?",
            isEBikeSpecific = true
        )

        createHolidaysTemplateActivity(
            title = "Consider rebuilding motor/bearings",
            description = "If out of warranty, consider rebuilding motor/bearings from places like ebike motor centre",
            isEBikeSpecific = true
        )

        createHolidaysTemplateActivity(
            title = "Take extra battery",
            description = "Extra battery (or does currently battery have good enough condition for big days)",
            isEBikeSpecific = true
        )

        createHolidaysTemplateActivity(
            title = "Check electric cables",
            description = "Electric cables all with smooth run and no kinks",
            isEBikeSpecific = true
        )

        return resultingList
    }

    fun createQuickRideTemplateActivity(
        title: String,
        description: String,
        isEBikeSpecific: Boolean = false
    ) {
        val templateActivity = TemplateActivity(
            rideLevel = RideLevel.getRideLevelQuickRide(),
            title = title,
            description = description,
            isEBikeSpecific = isEBikeSpecific,
            typeOfTemplate = TemplateActivityType.BUILT_IN
        )
        resultingList.add(templateActivity)
    }

    fun createDayOutTemplateActivity(
        title: String,
        description: String,
        isEBikeSpecific: Boolean = false
    ) {
        val templateActivity = TemplateActivity(
            rideLevel = RideLevel.getRideLevelDayOut(),
            title = title,
            description = description,
            isEBikeSpecific = isEBikeSpecific,
            typeOfTemplate = TemplateActivityType.BUILT_IN
        )
        resultingList.add(templateActivity)
    }

    fun createHolidaysTemplateActivity(
        title: String,
        description: String,
        isEBikeSpecific: Boolean = false
    ) {
        val templateActivity = TemplateActivity(
            rideLevel = RideLevel.getRideLevelHolidays(),
            title = title,
            description = description,
            isEBikeSpecific = isEBikeSpecific,
            typeOfTemplate = TemplateActivityType.BUILT_IN
        )
        resultingList.add(templateActivity)
    }
}

class PopulateDatabaseHelpersViaRepository(
    val repository: KJsRepository
) {
    suspend fun createFallbackTemplateActivities() {
        val createDatabaseHelper = PopulateDatabaseHelpers()
        val templateActivities = createDatabaseHelper.generatePreparationTemplateActivities()
        templateActivities.forEach { templateActivity ->
            repository.insertTemplateActivity(templateActivity)
        }
    }
}

class PopulateDatabaseHelpersViaProvider(
    val provider: Provider<KJsDAO>
) {
    suspend fun createFallbackTemplateActivities() {
        val createDatabaseHelper = PopulateDatabaseHelpers()
        val templateActivities = createDatabaseHelper.generatePreparationTemplateActivities()
        templateActivities.forEach { templateActivity ->
            provider.get().insertTemplateActivity(templateActivity)
        }
    }
}
