package com.exner.tools.jkbikemechanicaldisasterprevention.database

import androidx.room.Database
import androidx.room.RoomDatabase
import androidx.room.TypeConverters
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Activity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.ActivityTags
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.BackgroundWorkLog
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Bike
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Component
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.IntervalsSummaryGear
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Ride
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.StravaSummaryGear
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.Tag
import com.exner.tools.jkbikemechanicaldisasterprevention.database.entities.TemplateActivity
import com.exner.tools.jkbikemechanicaldisasterprevention.database.views.ActivitiesButNotForCompletedRides
import com.exner.tools.jkbikemechanicaldisasterprevention.database.views.ActivityWithBikeAndRideData
import com.exner.tools.jkbikemechanicaldisasterprevention.database.views.RetiredComponents
import com.exner.tools.jkbikemechanicaldisasterprevention.database.views.RideWithBikeAndActivityTotals
import com.exner.tools.jkbikemechanicaldisasterprevention.database.views.ShelvedComponents

@Database(
    entities = [
        Activity::class,
        Tag::class,
        ActivityTags::class,
        Bike::class,
        Ride::class,
        TemplateActivity::class,
        Component::class,
        BackgroundWorkLog::class,
        StravaSummaryGear::class,
        IntervalsSummaryGear::class
    ],
    views = [
        ActivityWithBikeAndRideData::class,
        ActivitiesButNotForCompletedRides::class,
        RideWithBikeAndActivityTotals::class,
        ShelvedComponents::class,
        RetiredComponents::class
    ],
    version = 15,
    exportSchema = true
)
@TypeConverters(
    DataConverter::class,
//    builtInTypeConverters = BuiltInTypeConverters()
)
abstract class KJsDatabase : RoomDatabase() {
    abstract fun dataDAO(): KJsDAO
}