package com.exner.tools.jkbikemechanicaldisasterprevention

import android.app.Application
import androidx.work.Configuration
import com.exner.tools.jkbikemechanicaldisasterprevention.di.CommonWorkerFactory
import com.google.android.material.color.DynamicColors
import dagger.hilt.android.HiltAndroidApp
import javax.inject.Inject

@HiltAndroidApp
class KJsApplication : Application(), Configuration.Provider {

    override fun onCreate() {
        super.onCreate()

        // let's try dynamic colours
        DynamicColors.applyToActivitiesIfAvailable(this)
    }

    @Inject
    lateinit var workerFactory: CommonWorkerFactory
    
    override val workManagerConfiguration: Configuration
        get() = Configuration.Builder()
            .setMinimumLoggingLevel(android.util.Log.DEBUG)
            .setWorkerFactory(workerFactory)
            .build()
}