/*
 * Copyright 2014-2019 Igor Almeida
 * Copyright 2025 Philip Kaludercic
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see http://www.gnu.org/licenses/.
 */

package com.example.muzei.muzeiartvee;

import android.net.Uri;
import android.util.Log;
import android.widget.Toast;

import com.google.android.apps.muzei.api.provider.Artwork;
import com.google.android.apps.muzei.api.provider.MuzeiArtProvider;

import org.jsoup.Jsoup;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.regex.Pattern;

public class ArtveeArtSource extends MuzeiArtProvider {
    protected static final String TAG = "ArtveeForMuzei";
    private static final Pattern pattern = Pattern.compile("/([a-zA-Z0-9]+)\\.jpg$");

    @Override
    public void onLoadRequested(boolean initial) {
        try {
            var url = new URI("https://artvee.com/highlights/").toURL();
            var doc = Jsoup.parse(url, 5000);

            for (var element : doc.body().select(".unsnax")) {
                var img = element.select("img");
                var title = element.select("h3.product-title a");
                var artist = element.select(".woodmart-product-brands-links");

                var src = img.attr("src");
                var pat = pattern.matcher(src);
                if (!pat.find()) {
                    continue;
                }
                var id = pat.group(1);

                var artwork = new Artwork.Builder()
                        .title(title.text())
                        .byline(artist.text())
                        .persistentUri(Uri.parse(String.format("https://mdl.artvee.com/sdl/%ssdl.jpg", id)))
                        .token(id)
                        .webUri(Uri.parse(title.attr("href")))
                        .build();
                addArtwork(artwork);
            }
        } catch (URISyntaxException | IOException e) {
            Toast.makeText(getContext(), e.getMessage(), Toast.LENGTH_SHORT).show();
            Log.e("ArtveeForMuzei", "Error loading artwork", e);
        }
    }
}

