// En el archivo ui/theme/Theme.kt

package com.example.controldecolonias.ui.theme

import android.app.Activity
import android.os.Build
import androidx.compose.foundation.isSystemInDarkTheme
import androidx.compose.material3.MaterialTheme
import androidx.compose.material3.darkColorScheme
import androidx.compose.material3.dynamicDarkColorScheme
import androidx.compose.material3.dynamicLightColorScheme
import androidx.compose.material3.lightColorScheme
import androidx.compose.runtime.Composable
import androidx.compose.runtime.SideEffect
import androidx.compose.ui.graphics.toArgb
import androidx.compose.ui.platform.LocalContext
import androidx.compose.ui.platform.LocalView
import androidx.core.view.WindowCompat

// MODIFICADO: Definimos nuestra paleta para el tema oscuro
private val DarkColorScheme = darkColorScheme(
    primary = LightGreen,
    secondary = Brown,
    tertiary = Pink80
)

// MODIFICADO: Definimos nuestra paleta para el tema claro
private val LightColorScheme = lightColorScheme(
    primary = DarkGreen,
    secondary = Brown,
    tertiary = Pink40
)

@Composable
fun ControlDeColoniasTheme(
    darkTheme: Boolean = isSystemInDarkTheme(), // Detecta automáticamente el tema del sistema
    dynamicColor: Boolean = true, // Color dinámico en Android 12+
    content: @Composable () -> Unit
) {
    // MODIFICADO: Elegimos qué paleta de colores usar
    val colorScheme = when {
        dynamicColor && Build.VERSION.SDK_INT >= Build.VERSION_CODES.S -> {
            val context = LocalContext.current
            if (darkTheme) dynamicDarkColorScheme(context) else dynamicLightColorScheme(context)
        }
        darkTheme -> DarkColorScheme
        else -> LightColorScheme
    }

    val view = LocalView.current
    if (!view.isInEditMode) {
        SideEffect {
            val window = (view.context as Activity).window
            window.statusBarColor = colorScheme.primary.toArgb()
            WindowCompat.getInsetsController(window, view).isAppearanceLightStatusBars = !darkTheme
        }
    }

    MaterialTheme(
        colorScheme = colorScheme,
        typography = Typography,
        content = content
    )
}