package com.example.controldecolonias.util

import android.content.Context
import androidx.datastore.core.DataStore
import androidx.datastore.preferences.core.Preferences
import androidx.datastore.preferences.core.booleanPreferencesKey
import androidx.datastore.preferences.core.edit
import androidx.datastore.preferences.core.stringPreferencesKey
import androidx.datastore.preferences.preferencesDataStore
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.map

private val Context.dataStore: DataStore<Preferences> by preferencesDataStore(name = "settings")

class SettingsManager(context: Context) {

    private val dataStore = context.dataStore

    companion object {
        val API_KEY = stringPreferencesKey("api_key")
        // NUEVA LLAVE PARA EL MODO NINJA
        val NINJA_MODE_ENABLED = booleanPreferencesKey("ninja_mode_enabled")
    }

    suspend fun guardarApiKey(apiKey: String) {
        dataStore.edit { settings ->
            settings[API_KEY] = apiKey
        }
    }

    val apiKeyFlow: Flow<String> = dataStore.data.map { preferences ->
        preferences[API_KEY] ?: ""
    }

    // NUEVAS FUNCIONES PARA EL MODO NINJA
    suspend fun guardarNinjaMode(activado: Boolean) {
        dataStore.edit { settings ->
            settings[NINJA_MODE_ENABLED] = activado
        }
    }

    val ninjaModeFlow: Flow<Boolean> = dataStore.data.map { preferences ->
        preferences[NINJA_MODE_ENABLED] ?: false // Por defecto, está desactivado
    }
}