package com.example.controldecolonias

import androidx.room.Entity
import androidx.room.ForeignKey
import androidx.room.Index
import androidx.room.PrimaryKey

@Entity(
    tableName = "fotos_table",
    foreignKeys = [ForeignKey(
        entity = Colonia::class,
        parentColumns = ["id"],
        childColumns = ["coloniaId"],
        onDelete = ForeignKey.CASCADE
    )],
    // AÑADIDO: Índice para mejorar rendimiento
    indices = [Index(value = ["coloniaId"])]
)
data class Foto(
    @PrimaryKey(autoGenerate = true)
    val id: Int = 0,
    val coloniaId: String,
    val uri: String,
    val descripcion: String,
    val fecha: Long = System.currentTimeMillis()
)