# Contributing To Evil Insult Generator

👍🎉 First off, thanks for taking the time to contribute! 🎉👍

The following is a set of guidelines for contributing to [Evil Insult Generator](https://evilinsult.com/), which are hosted on [GitHub](https://github.com/EvilInsultGenerator/).
These are just guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## What should I know before I get started?

### Code of Conduct

This project adheres to the [Contributor Covenant code of conduct](https://contributor-covenant.org/version/1/4/).
By participating, you are expected to uphold this code. Please report unacceptable behavior to [marvin@evilinsult.com](mailto:marvin@evilinsult.com).

### Contact

If you have any questions or are unsure about something just drop a line to [marvin@evilinsult.com](mailto:marvin@evilinsult.com).

### Design Decisions

If you plan to make a significant decision in how to maintain the project and what it can or cannot support please send an email beforehand. 

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for [Evil Insult Generator](https://evilinsult.com/) software. Following these guidelines helps maintainers and the community understand your report 📝, reproduce the behavior 📱💻🎮, and find related reports 🔎.

Before creating bug reports, please check this list as you might find out that you don't need to create one. When you are creating a bug report, please include as many details as possible.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for [Evil Insult Generator](https://evilinsult.com/), including completely new features and minor improvements to existing functionality. Following these guidelines helps maintainers and the community understand your suggestion 📝 and find related suggestions 🔎.

Before creating enhancement suggestions, please check this list as you might find out that you don't need to create one. When you are creating an enhancement suggestion, please include as many details as possible.

### Pull Requests

+ Include screenshots and animated GIFs in your pull request whenever possible.
+ Create a [branch](https://guides.github.com/introduction/flow/) for your edit
    
### Git Commit Messages

+ Use the present tense ("Add feature" not "Added feature")
+ Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
+ Limit the first line to 72 characters or less
+ Reference issues and pull requests liberally
+ When only changing documentation, include [ci skip] in the commit description
+ Consider starting the commit message with an applicable emoji:

        🎨 :art: when improving the format/structure of the code
        🐎 :racehorse: when improving performance
        🚱 :non-potable_water: when plugging memory leaks
        📝 :memo: when writing docs
        🐧 :penguin: when fixing something on Linux
        🍎 :apple: when fixing something on macOS
        🏁 :checkered_flag: when fixing something on Windows
        🐛 :bug: when fixing a bug
        🔥 :fire: when removing code or files
        💚 :green_heart: when fixing the CI build
        ✅ :white_check_mark: when adding tests
        🔒 :lock: when dealing with security
        ⬆️ :arrow_up: when upgrading dependencies
        ⬇️ :arrow_down: when downgrading dependencies
        👕 :shirt: when removing linter warnings
        
        
__Thank you so much! 😘__
