/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/* This file is automatically generated by the gen-unicode.py script
 * from UnicodeData-9.0.0.txt. Do not edit! */

/**
 * Character interval starting points for the unicode letters.
 *
 * The characters covered by these intervals are from
 * the following Unicode categories: Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint16_t lit_unicode_letter_interval_sps[] JERRY_ATTR_CONST_DATA =
{
  0x00c0, 0x00d8, 0x00f8, 0x01f8, 0x02c6, 0x02e0, 0x0370, 0x0376, 0x037a, 0x0388,
  0x038e, 0x03a3, 0x03f7, 0x048a, 0x0531, 0x0561, 0x05d0, 0x05f0, 0x0620, 0x066e,
  0x0671, 0x06e5, 0x06ee, 0x06fa, 0x0712, 0x074d, 0x07ca, 0x07f4, 0x0800, 0x0840,
  0x08a0, 0x08b6, 0x0904, 0x0958, 0x0971, 0x0985, 0x098f, 0x0993, 0x09aa, 0x09b6,
  0x09dc, 0x09df, 0x09f0, 0x0a05, 0x0a0f, 0x0a13, 0x0a2a, 0x0a32, 0x0a35, 0x0a38,
  0x0a59, 0x0a72, 0x0a85, 0x0a8f, 0x0a93, 0x0aaa, 0x0ab2, 0x0ab5, 0x0ae0, 0x0b05,
  0x0b0f, 0x0b13, 0x0b2a, 0x0b32, 0x0b35, 0x0b5c, 0x0b5f, 0x0b85, 0x0b8e, 0x0b92,
  0x0b99, 0x0b9e, 0x0ba3, 0x0ba8, 0x0bae, 0x0c05, 0x0c0e, 0x0c12, 0x0c2a, 0x0c58,
  0x0c60, 0x0c85, 0x0c8e, 0x0c92, 0x0caa, 0x0cb5, 0x0ce0, 0x0cf1, 0x0d05, 0x0d0e,
  0x0d12, 0x0d54, 0x0d5f, 0x0d7a, 0x0d85, 0x0d9a, 0x0db3, 0x0dc0, 0x0e01, 0x0e32,
  0x0e40, 0x0e81, 0x0e87, 0x0e94, 0x0e99, 0x0ea1, 0x0eaa, 0x0ead, 0x0eb2, 0x0ec0,
  0x0edc, 0x0f40, 0x0f49, 0x0f88, 0x1000, 0x1050, 0x105a, 0x1065, 0x106e, 0x1075,
  0x10a0, 0x10d0, 0x10fc, 0x11fc, 0x124a, 0x1250, 0x125a, 0x1260, 0x128a, 0x1290,
  0x12b2, 0x12b8, 0x12c2, 0x12c8, 0x12d8, 0x1312, 0x1318, 0x1380, 0x13a0, 0x13f8,
  0x1401, 0x1501, 0x1601, 0x166f, 0x1681, 0x16a0, 0x16ee, 0x1700, 0x170e, 0x1720,
  0x1740, 0x1760, 0x176e, 0x1780, 0x1820, 0x1880, 0x1887, 0x18b0, 0x1900, 0x1950,
  0x1970, 0x1980, 0x19b0, 0x1a00, 0x1a20, 0x1b05, 0x1b45, 0x1b83, 0x1bae, 0x1bba,
  0x1c00, 0x1c4d, 0x1c5a, 0x1c80, 0x1ce9, 0x1cee, 0x1cf5, 0x1d00, 0x1e00, 0x1f00,
  0x1f18, 0x1f20, 0x1f48, 0x1f50, 0x1f5f, 0x1f80, 0x1fb6, 0x1fc2, 0x1fc6, 0x1fd0,
  0x1fd6, 0x1fe0, 0x1ff2, 0x1ff6, 0x2090, 0x210a, 0x2119, 0x212a, 0x212f, 0x213c,
  0x2145, 0x2160, 0x2c00, 0x2c30, 0x2c60, 0x2ceb, 0x2cf2, 0x2d00, 0x2d30, 0x2d80,
  0x2da0, 0x2da8, 0x2db0, 0x2db8, 0x2dc0, 0x2dc8, 0x2dd0, 0x2dd8, 0x3005, 0x3021,
  0x3031, 0x3038, 0x3041, 0x309d, 0x30a1, 0x30fc, 0x3105, 0x3131, 0x31a0, 0x31f0,
  0x3400, 0x3500, 0x3600, 0x3700, 0x3800, 0x3900, 0x3a00, 0x3b00, 0x3c00, 0x3d00,
  0x3e00, 0x3f00, 0x4000, 0x4100, 0x4200, 0x4300, 0x4400, 0x4500, 0x4600, 0x4700,
  0x4800, 0x4900, 0x4a00, 0x4b00, 0x4c00, 0x4d00, 0x4e00, 0x4f00, 0x5000, 0x5100,
  0x5200, 0x5300, 0x5400, 0x5500, 0x5600, 0x5700, 0x5800, 0x5900, 0x5a00, 0x5b00,
  0x5c00, 0x5d00, 0x5e00, 0x5f00, 0x6000, 0x6100, 0x6200, 0x6300, 0x6400, 0x6500,
  0x6600, 0x6700, 0x6800, 0x6900, 0x6a00, 0x6b00, 0x6c00, 0x6d00, 0x6e00, 0x6f00,
  0x7000, 0x7100, 0x7200, 0x7300, 0x7400, 0x7500, 0x7600, 0x7700, 0x7800, 0x7900,
  0x7a00, 0x7b00, 0x7c00, 0x7d00, 0x7e00, 0x7f00, 0x8000, 0x8100, 0x8200, 0x8300,
  0x8400, 0x8500, 0x8600, 0x8700, 0x8800, 0x8900, 0x8a00, 0x8b00, 0x8c00, 0x8d00,
  0x8e00, 0x8f00, 0x9000, 0x9100, 0x9200, 0x9300, 0x9400, 0x9500, 0x9600, 0x9700,
  0x9800, 0x9900, 0x9a00, 0x9b00, 0x9c00, 0x9d00, 0x9e00, 0x9f00, 0xa000, 0xa100,
  0xa200, 0xa300, 0xa400, 0xa4d0, 0xa500, 0xa600, 0xa610, 0xa62a, 0xa640, 0xa67f,
  0xa6a0, 0xa717, 0xa722, 0xa78b, 0xa7b0, 0xa7f7, 0xa803, 0xa807, 0xa80c, 0xa840,
  0xa882, 0xa8f2, 0xa90a, 0xa930, 0xa960, 0xa984, 0xa9e0, 0xa9e6, 0xa9fa, 0xaa00,
  0xaa40, 0xaa44, 0xaa60, 0xaa7e, 0xaab5, 0xaab9, 0xaadb, 0xaae0, 0xaaf2, 0xab01,
  0xab09, 0xab11, 0xab20, 0xab28, 0xab30, 0xab5c, 0xab70, 0xac00, 0xad00, 0xae00,
  0xaf00, 0xb000, 0xb100, 0xb200, 0xb300, 0xb400, 0xb500, 0xb600, 0xb700, 0xb800,
  0xb900, 0xba00, 0xbb00, 0xbc00, 0xbd00, 0xbe00, 0xbf00, 0xc000, 0xc100, 0xc200,
  0xc300, 0xc400, 0xc500, 0xc600, 0xc700, 0xc800, 0xc900, 0xca00, 0xcb00, 0xcc00,
  0xcd00, 0xce00, 0xcf00, 0xd000, 0xd100, 0xd200, 0xd300, 0xd400, 0xd500, 0xd600,
  0xd700, 0xd7b0, 0xd7cb, 0xf900, 0xfa00, 0xfa70, 0xfb00, 0xfb13, 0xfb1f, 0xfb2a,
  0xfb38, 0xfb40, 0xfb43, 0xfb46, 0xfbd3, 0xfcd3, 0xfd50, 0xfd92, 0xfdf0, 0xfe70,
  0xfe76, 0xff21, 0xff41, 0xff66, 0xffc2, 0xffca, 0xffd2, 0xffda
};

/**
 * Character lengths for the unicode letters.
 *
 * The characters covered by these intervals are from
 * the following Unicode categories: Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint8_t lit_unicode_letter_interval_lengths[] JERRY_ATTR_CONST_DATA =
{
  0x0016, 0x001e, 0x00ff, 0x00c9, 0x000b, 0x0004, 0x0004, 0x0001, 0x0003, 0x0002,
  0x0013, 0x0052, 0x008a, 0x00a5, 0x0025, 0x0026, 0x001a, 0x0002, 0x002a, 0x0001,
  0x0062, 0x0001, 0x0001, 0x0002, 0x001d, 0x0058, 0x0020, 0x0001, 0x0015, 0x0018,
  0x0014, 0x0007, 0x0035, 0x0009, 0x000f, 0x0007, 0x0001, 0x0015, 0x0006, 0x0003,
  0x0001, 0x0002, 0x0001, 0x0005, 0x0001, 0x0015, 0x0006, 0x0001, 0x0001, 0x0001,
  0x0003, 0x0002, 0x0008, 0x0002, 0x0015, 0x0006, 0x0001, 0x0004, 0x0001, 0x0007,
  0x0001, 0x0015, 0x0006, 0x0001, 0x0004, 0x0001, 0x0002, 0x0005, 0x0002, 0x0003,
  0x0001, 0x0001, 0x0001, 0x0002, 0x000b, 0x0007, 0x0002, 0x0016, 0x000f, 0x0002,
  0x0001, 0x0007, 0x0002, 0x0016, 0x0009, 0x0004, 0x0001, 0x0001, 0x0007, 0x0002,
  0x0028, 0x0002, 0x0002, 0x0005, 0x0011, 0x0017, 0x0008, 0x0006, 0x002f, 0x0001,
  0x0006, 0x0001, 0x0001, 0x0003, 0x0006, 0x0002, 0x0001, 0x0003, 0x0001, 0x0004,
  0x0003, 0x0007, 0x0023, 0x0004, 0x002a, 0x0005, 0x0003, 0x0001, 0x0002, 0x000c,
  0x0025, 0x002a, 0x00ff, 0x004c, 0x0003, 0x0006, 0x0003, 0x0028, 0x0003, 0x0020,
  0x0003, 0x0006, 0x0003, 0x000e, 0x0038, 0x0003, 0x0042, 0x000f, 0x0055, 0x0005,
  0x00ff, 0x00ff, 0x006b, 0x0010, 0x0019, 0x004a, 0x000a, 0x000c, 0x0003, 0x0011,
  0x0011, 0x000c, 0x0002, 0x0033, 0x0057, 0x0004, 0x0021, 0x0045, 0x001e, 0x001d,
  0x0004, 0x002b, 0x0019, 0x0016, 0x0034, 0x002e, 0x0006, 0x001d, 0x0001, 0x002b,
  0x0023, 0x0002, 0x0023, 0x0008, 0x0003, 0x0003, 0x0001, 0x00bf, 0x00ff, 0x0015,
  0x0005, 0x0025, 0x0005, 0x0007, 0x001e, 0x0034, 0x0006, 0x0002, 0x0006, 0x0003,
  0x0005, 0x000c, 0x0002, 0x0006, 0x000c, 0x0009, 0x0004, 0x0003, 0x000a, 0x0003,
  0x0004, 0x0028, 0x002e, 0x002e, 0x0084, 0x0003, 0x0001, 0x0025, 0x0037, 0x0016,
  0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0006, 0x0002, 0x0008,
  0x0004, 0x0004, 0x0055, 0x0002, 0x0059, 0x0003, 0x0028, 0x005d, 0x001a, 0x000f,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00b5, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00d5, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x008c, 0x002d, 0x00ff, 0x000c, 0x000f, 0x0001, 0x002e, 0x001e,
  0x004f, 0x0008, 0x0066, 0x0023, 0x0007, 0x000a, 0x0002, 0x0003, 0x0016, 0x0033,
  0x0031, 0x0005, 0x001b, 0x0016, 0x001c, 0x002e, 0x0004, 0x0009, 0x0004, 0x0028,
  0x0002, 0x0007, 0x0016, 0x0031, 0x0001, 0x0004, 0x0002, 0x000a, 0x0002, 0x0005,
  0x0005, 0x0005, 0x0006, 0x0006, 0x002a, 0x0009, 0x0072, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff, 0x00ff,
  0x00a3, 0x0016, 0x0030, 0x00ff, 0x006d, 0x0069, 0x0006, 0x0004, 0x0009, 0x000c,
  0x0004, 0x0001, 0x0001, 0x006b, 0x00ff, 0x006a, 0x003f, 0x0035, 0x000b, 0x0004,
  0x0086, 0x0019, 0x0019, 0x0058, 0x0005, 0x0005, 0x0005, 0x0002
};

/**
 * Those unicode letter characters that are not inside any of
 * the intervals specified in lit_unicode_letter_interval_sps array.
 *
 * The characters are from the following Unicode categories:
 * Lu, Ll, Lt, Lm, Lo, Nl
 */
static const uint16_t lit_unicode_letter_chars[] JERRY_ATTR_CONST_DATA =
{
  0x00aa, 0x00b5, 0x00ba, 0x02ec, 0x02ee, 0x037f, 0x0386, 0x038c, 0x0559, 0x06d5,
  0x06ff, 0x0710, 0x07b1, 0x07fa, 0x081a, 0x0824, 0x0828, 0x093d, 0x0950, 0x09b2,
  0x09bd, 0x09ce, 0x0a5e, 0x0abd, 0x0ad0, 0x0af9, 0x0b3d, 0x0b71, 0x0b83, 0x0b9c,
  0x0bd0, 0x0c3d, 0x0c80, 0x0cbd, 0x0cde, 0x0d3d, 0x0d4e, 0x0dbd, 0x0e84, 0x0e8a,
  0x0e8d, 0x0ea5, 0x0ea7, 0x0ebd, 0x0ec6, 0x0f00, 0x103f, 0x1061, 0x108e, 0x10c7,
  0x10cd, 0x1258, 0x12c0, 0x17d7, 0x17dc, 0x18aa, 0x1aa7, 0x1f59, 0x1f5b, 0x1f5d,
  0x1fbe, 0x2071, 0x207f, 0x2102, 0x2107, 0x2115, 0x2124, 0x2126, 0x2128, 0x214e,
  0x2d27, 0x2d2d, 0x2d6f, 0x2e2f, 0x3400, 0x4e00, 0xa8fb, 0xa8fd, 0xa9cf, 0xaa7a,
  0xaab1, 0xaac0, 0xaac2, 0xac00, 0xfb1d, 0xfb3e
};

/**
 * Character interval starting points for non-letter character
 * that can be used as a non-first character of an identifier.
 *
 * The characters covered by these intervals are from
 * the following Unicode categories: Nd, Mn, Mc, Pc
 */
static const uint16_t lit_unicode_non_letter_ident_part_interval_sps[] JERRY_ATTR_CONST_DATA =
{
  0x0300, 0x0483, 0x0591, 0x05c1, 0x05c4, 0x0610, 0x064b, 0x06d6, 0x06df, 0x06e7,
  0x06ea, 0x06f0, 0x0730, 0x07a6, 0x07c0, 0x07eb, 0x0816, 0x081b, 0x0825, 0x0829,
  0x0859, 0x08d4, 0x08e3, 0x093a, 0x093e, 0x0951, 0x0962, 0x0966, 0x0981, 0x09be,
  0x09c7, 0x09cb, 0x09e2, 0x09e6, 0x0a01, 0x0a3e, 0x0a47, 0x0a4b, 0x0a66, 0x0a81,
  0x0abe, 0x0ac7, 0x0acb, 0x0ae2, 0x0ae6, 0x0b01, 0x0b3e, 0x0b47, 0x0b4b, 0x0b56,
  0x0b62, 0x0b66, 0x0bbe, 0x0bc6, 0x0bca, 0x0be6, 0x0c00, 0x0c3e, 0x0c46, 0x0c4a,
  0x0c55, 0x0c62, 0x0c66, 0x0c81, 0x0cbe, 0x0cc6, 0x0cca, 0x0cd5, 0x0ce2, 0x0ce6,
  0x0d01, 0x0d3e, 0x0d46, 0x0d4a, 0x0d62, 0x0d66, 0x0d82, 0x0dcf, 0x0dd8, 0x0de6,
  0x0df2, 0x0e34, 0x0e47, 0x0e50, 0x0eb4, 0x0ebb, 0x0ec8, 0x0ed0, 0x0f18, 0x0f20,
  0x0f3e, 0x0f71, 0x0f86, 0x0f8d, 0x0f99, 0x102b, 0x1040, 0x1056, 0x105e, 0x1062,
  0x1067, 0x1071, 0x1082, 0x108f, 0x135d, 0x1712, 0x1732, 0x1752, 0x1772, 0x17b4,
  0x17e0, 0x180b, 0x1810, 0x1885, 0x1920, 0x1930, 0x1946, 0x19d0, 0x1a17, 0x1a55,
  0x1a60, 0x1a7f, 0x1a90, 0x1ab0, 0x1b00, 0x1b34, 0x1b50, 0x1b6b, 0x1b80, 0x1ba1,
  0x1bb0, 0x1be6, 0x1c24, 0x1c40, 0x1c50, 0x1cd0, 0x1cd4, 0x1cf2, 0x1cf8, 0x1dc0,
  0x1dfb, 0x203f, 0x20d0, 0x20e5, 0x2cef, 0x2de0, 0x302a, 0x3099, 0xa620, 0xa674,
  0xa69e, 0xa6f0, 0xa823, 0xa880, 0xa8b4, 0xa8d0, 0xa8e0, 0xa900, 0xa926, 0xa947,
  0xa980, 0xa9b3, 0xa9d0, 0xa9f0, 0xaa29, 0xaa4c, 0xaa50, 0xaa7b, 0xaab2, 0xaab7,
  0xaabe, 0xaaeb, 0xaaf5, 0xabe3, 0xabec, 0xabf0, 0xfe00, 0xfe20, 0xfe33, 0xfe4d,
  0xff10
};

/**
 * Character interval lengths for non-letter character
 * that can be used as a non-first character of an identifier.
 *
 * The characters covered by these intervals are from
 * the following Unicode categories: Nd, Mn, Mc, Pc
 */
static const uint8_t lit_unicode_non_letter_ident_part_interval_lengths[] JERRY_ATTR_CONST_DATA =
{
  0x006f, 0x0004, 0x002c, 0x0001, 0x0001, 0x000a, 0x001e, 0x0006, 0x0005, 0x0001,
  0x0003, 0x0009, 0x001a, 0x000a, 0x0009, 0x0008, 0x0003, 0x0008, 0x0002, 0x0004,
  0x0002, 0x000d, 0x0020, 0x0002, 0x0011, 0x0006, 0x0001, 0x0009, 0x0002, 0x0006,
  0x0001, 0x0002, 0x0001, 0x0009, 0x0002, 0x0004, 0x0001, 0x0002, 0x000b, 0x0002,
  0x0007, 0x0002, 0x0002, 0x0001, 0x0009, 0x0002, 0x0006, 0x0001, 0x0002, 0x0001,
  0x0001, 0x0009, 0x0004, 0x0002, 0x0003, 0x0009, 0x0003, 0x0006, 0x0002, 0x0003,
  0x0001, 0x0001, 0x0009, 0x0002, 0x0006, 0x0002, 0x0003, 0x0001, 0x0001, 0x0009,
  0x0002, 0x0006, 0x0002, 0x0003, 0x0001, 0x0009, 0x0001, 0x0005, 0x0007, 0x0009,
  0x0001, 0x0006, 0x0007, 0x0009, 0x0005, 0x0001, 0x0005, 0x0009, 0x0001, 0x0009,
  0x0001, 0x0013, 0x0001, 0x000a, 0x0023, 0x0013, 0x0009, 0x0003, 0x0002, 0x0002,
  0x0006, 0x0003, 0x000b, 0x000e, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x001f,
  0x0009, 0x0002, 0x0009, 0x0001, 0x000b, 0x000b, 0x0009, 0x0009, 0x0004, 0x0009,
  0x001c, 0x000a, 0x0009, 0x000d, 0x0004, 0x0010, 0x0009, 0x0008, 0x0002, 0x000c,
  0x0009, 0x000d, 0x0013, 0x0009, 0x0009, 0x0002, 0x0014, 0x0002, 0x0001, 0x0035,
  0x0004, 0x0001, 0x000c, 0x000b, 0x0002, 0x001f, 0x0005, 0x0001, 0x0009, 0x0009,
  0x0001, 0x0001, 0x0004, 0x0001, 0x0011, 0x0009, 0x0011, 0x0009, 0x0007, 0x000c,
  0x0003, 0x000d, 0x0009, 0x0009, 0x000d, 0x0001, 0x0009, 0x0002, 0x0002, 0x0001,
  0x0001, 0x0004, 0x0001, 0x0007, 0x0001, 0x0009, 0x000f, 0x000f, 0x0001, 0x0002,
  0x0009
};

/**
 * Those non-letter characters that can be used as a non-first
 * character of an identifier and not included in any of the intervals
 * specified in lit_unicode_non_letter_ident_part_interval_sps array.
 *
 * The characters are from the following Unicode categories:
 * Nd, Mn, Mc, Pc
 */
static const uint16_t lit_unicode_non_letter_ident_part_chars[] JERRY_ATTR_CONST_DATA =
{
  0x05bf, 0x05c7, 0x0670, 0x0711, 0x09bc, 0x09d7, 0x0a3c, 0x0a51, 0x0a75, 0x0abc,
  0x0b3c, 0x0b82, 0x0bd7, 0x0cbc, 0x0d57, 0x0dca, 0x0dd6, 0x0e31, 0x0eb1, 0x0f35,
  0x0f37, 0x0f39, 0x0fc6, 0x17dd, 0x18a9, 0x1ced, 0x2054, 0x20e1, 0x2d7f, 0xa66f,
  0xa802, 0xa806, 0xa80b, 0xa9e5, 0xaa43, 0xaab0, 0xaac1, 0xfb1e, 0xff3f
};

/**
 * Unicode separator character interval starting points from Unicode category: Zs
 */
static const uint16_t lit_unicode_separator_char_interval_sps[] JERRY_ATTR_CONST_DATA =
{
  0x2000
};

/**
 * Unicode separator character interval lengths from Unicode category: Zs
 */
static const uint8_t lit_unicode_separator_char_interval_lengths[] JERRY_ATTR_CONST_DATA =
{
  0x000b
};

/**
 * Unicode separator characters that are not in the
 * lit_unicode_separator_char_intervals array.
 *
 * Unicode category: Zs
 */
static const uint16_t lit_unicode_separator_chars[] JERRY_ATTR_CONST_DATA =
{
  0x1680, 0x180e, 0x202f, 0x205f, 0x3000
};
