/* Copyright JS Foundation and other contributors, http://js.foundation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "ecma-builtins.h"
#include "ecma-exceptions.h"
#include "ecma-gc.h"
#include "ecma-globals.h"
#include "ecma-helpers.h"
#include "ecma-typedarray-object.h"
#include "jrt.h"

#if ENABLED (JERRY_ES2015_BUILTIN_TYPEDARRAY)

#define ECMA_BUILTINS_INTERNAL
#include "ecma-builtins-internal.h"

#define BUILTIN_INC_HEADER_NAME "ecma-builtin-uint32array.inc.h"
#define BUILTIN_UNDERSCORED_ID uint32array
#include "ecma-builtin-internal-routines-template.inc.h"

#include "ecma-builtin-typedarray-helpers.h"

/** \addtogroup ecma ECMA
 * @{
 *
 * \addtogroup ecmabuiltins
 * @{
 *
 * \addtogroup uint32array ECMA Uint32Array object built-in
 * @{
 */

/**
 * Handle calling [[Call]] of Uint32Array
 *
 * @return ecma value
 */
ecma_value_t
ecma_builtin_uint32array_dispatch_call (const ecma_value_t *arguments_list_p, /**< arguments list */
                                        ecma_length_t arguments_list_len) /**< number of arguments */
{
  JERRY_ASSERT (arguments_list_len == 0 || arguments_list_p != NULL);

  return ecma_raise_type_error (ECMA_ERR_MSG ("Uint32Array cannot be directly called"));
} /* ecma_builtin_uint32array_dispatch_call */

/**
 * Handle calling [[Construct]] of Uint32Array
 *
 * @return ecma value
 */
ecma_value_t
ecma_builtin_uint32array_dispatch_construct (const ecma_value_t *arguments_list_p, /**< arguments list */
                                             ecma_length_t arguments_list_len) /**< number of arguments */
{
  JERRY_ASSERT (arguments_list_len == 0 || arguments_list_p != NULL);

  return ecma_typedarray_helper_dispatch_construct (arguments_list_p, arguments_list_len,
                                                    ECMA_UINT32_ARRAY);
} /* ecma_builtin_uint32array_dispatch_construct */

/**
  * @}
  * @}
  * @}
  */

#endif /* ENABLED (JERRY_ES2015_BUILTIN_TYPEDARRAY) */
