package nodomain.freeyourgadget.gadgetbridge.service.devices.shokz

enum class ShokzCommand(
    val group: Int,
    val code: Int
) {
    BATTERY_GET(0x02, 0x0003),
    BATTERY_RET(0x02, 0x8003),
    CONTROLS_ACK(0x01, 0x8024),
    CONTROLS_GET(0x02, 0x001b),
    CONTROLS_RET(0x02, 0x801b),
    CONTROLS_SET(0x01, 0x0024),
    BUTTON_NEXT_ACK(0x01, 0x8008),
    BUTTON_NEXT(0x01, 0x0008),
    BUTTON_PAUSE_ACK(0x01, 0x8004),
    BUTTON_PAUSE(0x01, 0x0004),
    BUTTON_PLAY_ACK(0x01, 0x8003),
    BUTTON_PLAY(0x01, 0x0003),
    BUTTON_PREV_ACK(0x01, 0x8007),
    BUTTON_PREV(0x01, 0x0007),
    EQ_UNK_ACK_1(0x01, 0x800e),
    EQUALIZER_ACK(0x03, 0x0009),
    EQUALIZER_GET(0x02, 0x0008),
    EQUALIZER_RET(0x02, 0x8008),
    EQUALIZER_SET(0x01, 0x000e),
    FIRMWARE_GET(0x02, 0x0002),
    FIRMWARE_RET(0x02, 0x8002),
    LANGUAGE_ACK(0x01, 0x8002),
    LANGUAGE_GET(0x02, 0x0006),
    LANGUAGE_RET(0x02, 0x8006),
    LANGUAGE_SET(0x01, 0x0002),
    MEDIA_SOURCE_ACK(0x01, 0x8025),
    MEDIA_SOURCE_NOTIFY(0x03, 0x000c),
    MEDIA_SOURCE_SET(0x01, 0x0025),
    MODE_BLUETOOTH_UNK_0(0x03, 0x000d),
    MEDIA_SOURCE_GET(0x02, 0x001c),
    MEDIA_SOURCE_RET(0x02, 0x801c),
    MODE_MP3_ACK(0x02, 0x801e),
    MODE_MP3_SET(0x02, 0x001e),
    MP3_PLAYBACK_MODE_ACK(0x01, 0x8026),
    MP3_PLAYBACK_MODE_GET(0x02, 0x001d),
    MP3_PLAYBACK_MODE_RET(0x02, 0x801d),
    MP3_PLAYBACK_MODE_SET(0x01, 0x0026),
    MULTIPOINT_CONNECT_ACK(0x01, 0x800b),
    MULTIPOINT_CONNECT_REQ(0x01, 0x000b),
    MULTIPOINT_DEVICE_CONNECTION_NOTIFY(0x03, 0x000b),
    MULTIPOINT_DEVICES_GET(0x02, 0x0004),
    MULTIPOINT_DEVICES_RET(0x02, 0x8004),
    MULTIPOINT_DISCONNECT_ACK(0x01, 0x800c),
    MULTIPOINT_DISCONNECT_REQ(0x01, 0x000c),
    MULTIPOINT_OFF_ACK(0x01, 0x8010),
    MULTIPOINT_OFF(0x01, 0x0010),
    MULTIPOINT_ON_ACK(0x01, 0x8011),
    MULTIPOINT_ON(0x01, 0x0011),
    MULTIPOINT_PAIR_SECOND_FINISH(0x01, 0x0023),
    MULTIPOINT_START_PAIR_ACK(0x01, 0x8022),
    MULTIPOINT_START_PAIR_REQ(0x01, 0x001d),
    PLAYBACK_STATUS_GET(0x02, 0x0005),
    PLAYBACK_STATUS_NOTIFY(0x03, 0x0006),
    PLAYBACK_STATUS_RET(0x02, 0x8005),
    MULTIPOINT_GET(0x02, 0x0010),
    MULTIPOINT_RET(0x02, 0x8010),
    VOLUME_ACK(0x01, 0x800a),
    VOLUME_GET(0x02, 0x0007),
    VOLUME_NOTIFY(0x03, 0x0005),
    VOLUME_RET(0x02, 0x8007),
    VOLUME_SET(0x01, 0x000a),
    ;

    companion object {
        fun getCommand(group: Int, code: Int): ShokzCommand? = entries.find {
            it.group == group && it.code == code
        }
    }
}
