/*  Copyright (C) 2015-2024 Carsten Pfeiffer

    This file is part of Gadgetbridge.

    Gadgetbridge is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Gadgetbridge is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>. */
package nodomain.freeyourgadget.gadgetbridge.devices.pebble;

public class PebbleInstallable {
    final private byte type;
    final private int crc;
    final private String fileName;
    final private int fileSize;

    public PebbleInstallable(String fileName, int fileSize, int crc, byte type) {
        this.fileName = fileName;
        this.fileSize = fileSize;
        this.crc = crc;
        this.type = type;
    }

    public String getFileName() {
        return fileName;
    }

    public int getFileSize() {
        return fileSize;
    }

    public byte getType() {
        return type;
    }

    public int getCRC() {
        return crc;
    }
}
