/*  Copyright (C) 2015-2024 Andreas Shimokawa, Carsten Pfeiffer, Daniele
    Gobbetti

    This file is part of Gadgetbridge.

    Gadgetbridge is free software: you can redistribute it and/or modify
    it under the terms of the GNU Affero General Public License as published
    by the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    Gadgetbridge is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU Affero General Public License for more details.

    You should have received a copy of the GNU Affero General Public License
    along with this program.  If not, see <https://www.gnu.org/licenses/>. */
package nodomain.freeyourgadget.gadgetbridge.devices.miband;

import nodomain.freeyourgadget.gadgetbridge.entities.DaoSession;
import nodomain.freeyourgadget.gadgetbridge.impl.GBDevice;
import nodomain.freeyourgadget.gadgetbridge.model.ActivityKind;

public class MiBandSampleProvider extends AbstractMiBandSampleProvider {
    public static final int TYPE_DEEP_SLEEP = 4;
    public static final int TYPE_LIGHT_SLEEP = 5;
    public static final int TYPE_ACTIVITY = -1;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_NONWEAR = 3;
    public static final int TYPE_CHARGING = 6;

//    public static final byte TYPE_NREM = 5; // DEEP SLEEP
//    public static final byte TYPE_ONBED = 7;
//    public static final byte TYPE_REM = 4; // LIGHT SLEEP
//    public static final byte TYPE_RUNNING = 2;
//    public static final byte TYPE_SLIENT = 0;
//    public static final byte TYPE_USER = 100;
//    public static final byte TYPE_WALKING = 1;

    public MiBandSampleProvider(GBDevice device, DaoSession session) {
        super(device, session);
    }

    @Override
    public ActivityKind normalizeType(int rawType) {
        switch (rawType) {
            case TYPE_DEEP_SLEEP:
                return ActivityKind.DEEP_SLEEP;
            case TYPE_LIGHT_SLEEP:
                return ActivityKind.LIGHT_SLEEP;
            case TYPE_ACTIVITY:
                return ActivityKind.ACTIVITY;
            case TYPE_NONWEAR:
                return ActivityKind.NOT_WORN;
            case TYPE_CHARGING:
                return ActivityKind.NOT_WORN; //I believe it's a safe assumption
            default:
//            case TYPE_UNKNOWN: // fall through
                return ActivityKind.UNKNOWN;
        }
    }

    @Override
    public int toRawActivityKind(ActivityKind activityKind) {
        switch (activityKind) {
            case ACTIVITY:
                return TYPE_ACTIVITY;
            case DEEP_SLEEP:
                return TYPE_DEEP_SLEEP;
            case LIGHT_SLEEP:
                return TYPE_LIGHT_SLEEP;
            case NOT_WORN:
                return TYPE_NONWEAR;
            case UNKNOWN: // fall through
            default:
                return TYPE_UNKNOWN;
        }
    }
}
