/*
 *
 *   Copyright 2023 Einstein Blanco
 *
 *   Licensed under the GNU General Public License v3.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       https://www.gnu.org/licenses/gpl-3.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
package com.eblan.launcher.domain.model

data class ShortcutConfigGridItem(
    val id: String,
    val folderId: String?,
    val page: Int,
    val startColumn: Int,
    val startRow: Int,
    val columnSpan: Int,
    val rowSpan: Int,
    val associate: Associate,
    val componentName: String,
    val packageName: String,
    val activityIcon: String?,
    val activityLabel: String?,
    val applicationIcon: String?,
    val applicationLabel: String?,
    val override: Boolean,
    val serialNumber: Long,
    val shortcutIntentName: String?,
    val shortcutIntentIcon: String?,
    val shortcutIntentUri: String?,
    val customIcon: String?,
    val customLabel: String?,
    val gridItemSettings: GridItemSettings,
)
