/*
 *
 *   Copyright 2023 Einstein Blanco
 *
 *   Licensed under the GNU General Public License v3.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       https://www.gnu.org/licenses/gpl-3.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
package com.eblan.launcher.designsystem.icon

import androidx.compose.material.icons.Icons
import androidx.compose.material.icons.automirrored.filled.ArrowBack
import androidx.compose.material.icons.automirrored.filled.Shortcut
import androidx.compose.material.icons.filled.Add
import androidx.compose.material.icons.filled.Apps
import androidx.compose.material.icons.filled.ArrowDropDown
import androidx.compose.material.icons.filled.ArrowDropUp
import androidx.compose.material.icons.filled.Close
import androidx.compose.material.icons.filled.Delete
import androidx.compose.material.icons.filled.DeveloperMode
import androidx.compose.material.icons.filled.Edit
import androidx.compose.material.icons.filled.Folder
import androidx.compose.material.icons.filled.Gesture
import androidx.compose.material.icons.filled.Handshake
import androidx.compose.material.icons.filled.Home
import androidx.compose.material.icons.filled.Image
import androidx.compose.material.icons.filled.Info
import androidx.compose.material.icons.filled.OpenInFull
import androidx.compose.material.icons.filled.Pages
import androidx.compose.material.icons.filled.Restore
import androidx.compose.material.icons.filled.Save
import androidx.compose.material.icons.filled.Search
import androidx.compose.material.icons.filled.Settings
import androidx.compose.material.icons.filled.Widgets
import androidx.compose.material.icons.filled.Work
import androidx.compose.material.icons.filled.WorkOff

object EblanLauncherIcons {
    val Edit = Icons.Default.Edit
    val Resize = Icons.Default.OpenInFull
    val Delete = Icons.Default.Delete
    val ArrowBack = Icons.AutoMirrored.Filled.ArrowBack
    val Home = Icons.Default.Home
    val Widgets = Icons.Default.Widgets
    val Settings = Icons.Default.Settings
    val Pages = Icons.Default.Pages
    val Gesture = Icons.Default.Gesture
    val Folder = Icons.Default.Folder
    val Apps = Icons.Default.Apps
    val Image = Icons.Default.Image
    val Search = Icons.Default.Search
    val ArrowDropDown = Icons.Default.ArrowDropDown
    val ArrowDropUp = Icons.Default.ArrowDropUp
    val Info = Icons.Default.Info
    val Add = Icons.Default.Add
    val Work = Icons.Default.Work
    val WorkOff = Icons.Default.WorkOff
    val DeveloperMode = Icons.Default.DeveloperMode
    val Close = Icons.Default.Close
    val Save = Icons.Default.Save
    val Handshake = Icons.Default.Handshake
    val Shortcut = Icons.AutoMirrored.Filled.Shortcut
    val Restore = Icons.Default.Restore
}
