/*
 *
 *   Copyright 2023 Einstein Blanco
 *
 *   Licensed under the GNU General Public License v3.0 (the "License");
 *   you may not use this file except in compliance with the License.
 *   You may obtain a copy of the License at
 *
 *       https://www.gnu.org/licenses/gpl-3.0
 *
 *   Unless required by applicable law or agreed to in writing, software
 *   distributed under the License is distributed on an "AS IS" BASIS,
 *   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *   See the License for the specific language governing permissions and
 *   limitations under the License.
 *
 */
package com.eblan.launcher.data.room.dao

import androidx.room.Dao
import androidx.room.Delete
import androidx.room.Query
import androidx.room.Update
import androidx.room.Upsert
import com.eblan.launcher.data.room.entity.ShortcutInfoGridItemEntity
import com.eblan.launcher.domain.model.UpdateShortcutInfoGridItem
import kotlinx.coroutines.flow.Flow

@Dao
interface ShortcutInfoGridItemDao {
    @Query("SELECT * FROM ShortcutInfoGridItemEntity")
    fun getShortcutInfoGridItemEntities(): Flow<List<ShortcutInfoGridItemEntity>>

    @Upsert
    suspend fun upsertShortcutInfoGridItemEntities(entities: List<ShortcutInfoGridItemEntity>)

    @Update
    suspend fun updateShortcutInfoGridItemEntity(entity: ShortcutInfoGridItemEntity)

    @Delete
    suspend fun deleteShortcutInfoGridItemEntities(entities: List<ShortcutInfoGridItemEntity>)

    @Delete
    suspend fun deleteShortcutInfoGridItemEntity(entity: ShortcutInfoGridItemEntity)

    @Query("SELECT * FROM ShortcutInfoGridItemEntity WHERE serialNumber = :serialNumber AND packageName = :packageName")
    suspend fun getShortcutInfoGridItemEntities(
        serialNumber: Long,
        packageName: String,
    ): List<ShortcutInfoGridItemEntity>

    @Query("DELETE FROM ShortcutInfoGridItemEntity WHERE serialNumber = :serialNumber AND packageName = :packageName")
    suspend fun deleteShortcutInfoGridItemEntity(
        serialNumber: Long,
        packageName: String,
    )

    @Update(entity = ShortcutInfoGridItemEntity::class)
    suspend fun updateShortcutInfoGridItemEntities(updateShortcutInfoGridItems: List<UpdateShortcutInfoGridItem>)
}
