/*
 *   Graph89 - Emulator for Android
 *  
 *	 Copyright (C) 2012-2013  Dritan Hashorva
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.

 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>
 */

package com.graph89.common;

public class HighlightInfo
{
	public int					Code;
	public String				Key;
	public int					CenterX;
	public int					CenterY;
	public HighlightButtonType	ButtonType;

	public HighlightInfo(String[] parts, Highlights parent)
	{
		Code = Integer.parseInt(parts[0]);
		Key = parts[1];
		CenterX = Integer.parseInt(parts[2]);
		CenterY = Integer.parseInt(parts[3]);

		ButtonType = parent.FindButtonTypeByName(parts[4]);
	}

	public static boolean IsHighlightInfo(String[] parts)
	{
		return parts.length >= 5 && Character.isDigit(parts[0].charAt(0));
	}
}
