/*
 * Copyright (c) 2024 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.app.statistics.store

import androidx.room.Dao
import androidx.room.Insert
import androidx.room.OnConflictStrategy
import androidx.room.Query
import com.duckduckgo.app.statistics.model.UniquePixelFired

@Dao
interface UniquePixelFiredDao {

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    suspend fun insert(value: UniquePixelFired)

    @Query("SELECT COUNT(1) > 0 FROM unique_pixels_fired WHERE name = :name")
    suspend fun hasUniquePixelFired(name: String): Boolean
}
