/*
 * Copyright (c) 2025 DuckDuckGo
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package com.duckduckgo.app.fire.model

/**
 * Modules can implement this plugin to contribute top-level filenames inside [Context.getCacheDir]
 * that MUST be preserved when the app clears its cache directory.
 */
interface AppCacheExclusionPlugin {
    /**
     * @return list of filenames (top-level entries in cacheDir) that should NOT be deleted
     */
    fun filenamesExcludedFromDeletion(): List<String>
}
